/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.basic;

import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.element.PinDescriptions;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;

public abstract class FanIn
extends Node
implements Element,
Countable {
    public static final String PREFIX = "In_";
    private final ArrayList<ObservableValue> inputs;
    private final ObservableValue output;
    private final int bits;

    public FanIn(int bits) {
        this.bits = bits;
        this.inputs = new ArrayList();
        this.output = new ObservableValue("out", bits).setDescription(Lang.get("elem_Basic_Out", new Object[0]));
    }

    @Override
    public void setInputs(ObservableValues in) throws NodeException {
        for (ObservableValue v : in) {
            this.inputs.add(v.checkBits(this.bits, this).addObserverToValue(this));
        }
    }

    public ObservableValue getOutput() {
        return this.output;
    }

    public ArrayList<ObservableValue> getInputs() {
        return this.inputs;
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    @Override
    public int getInputsCount() {
        return this.inputs.size();
    }

    static class FanInDescription
    extends ElementTypeDescription {
        FanInDescription(Class<? extends Element> clazz) {
            super(clazz, new PinDescription[0]);
            this.addAttributes();
            this.supportsHDL();
        }

        private void addAttributes() {
            this.addAttribute(Keys.ROTATE);
            this.addAttribute(Keys.BITS);
            this.addAttribute(Keys.INPUT_COUNT);
            this.addAttribute(Keys.INVERTER_CONFIG);
        }

        @Override
        public PinDescriptions getInputDescription(ElementAttributes elementAttributes) {
            int count = elementAttributes.get(Keys.INPUT_COUNT);
            PinDescription[] names = new PinDescription[count];
            for (int i = 0; i < count; ++i) {
                names[i] = PinInfo.input(FanIn.PREFIX + (i + 1), Lang.get("elem_Basic_In", i + 1));
            }
            return new PinDescriptions(names);
        }
    }
}

