/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import java.util.Random;

public class PRNG
extends Node
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(PRNG.class, PinInfo.input("S"), PinInfo.input("se"), PinInfo.input("ne"), PinInfo.input("C").setClock()).addAttribute(Keys.ROTATE).addAttribute(Keys.BITS).addAttribute(Keys.LABEL);
    private final ObservableValue output;
    private final int bits;
    private final long mask;
    private final Random random;
    private ObservableValue seedVal;
    private ObservableValue setVal;
    private ObservableValue nextVal;
    private ObservableValue clockVal;
    private boolean lastClock;
    private long value;

    public PRNG(ElementAttributes attributes) {
        this.bits = attributes.get(Keys.BITS);
        this.output = new ObservableValue("R", this.bits).setPinDescription(DESCRIPTION);
        this.random = new Random();
        this.mask = Bits.mask(this.bits);
        this.value = this.random.nextLong() & this.mask;
    }

    @Override
    public void readInputs() throws NodeException {
        boolean clock = this.clockVal.getBool();
        if (clock && !this.lastClock) {
            if (this.setVal.getBool()) {
                this.random.setSeed(this.seedVal.getValue());
            }
            if (this.nextVal.getBool()) {
                this.value = this.random.nextLong() & this.mask;
            }
        }
        this.lastClock = clock;
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.output.setValue(this.value);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        this.seedVal = ((ObservableValue)inputs.get(0)).checkBits(this.bits, this);
        this.setVal = ((ObservableValue)inputs.get(1)).checkBits(1, this);
        this.nextVal = ((ObservableValue)inputs.get(2)).checkBits(1, this);
        this.clockVal = ((ObservableValue)inputs.get(3)).addObserverToValue(this).checkBits(1, this);
    }

    @Override
    public ObservableValues getOutputs() {
        return this.output.asList();
    }
}

