/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class Comparator
extends Node
implements Element,
Countable {
    private static final long MSB = Bits.signedFlagMask(64);
    private static final long LSB = MSB ^ 0xFFFFFFFFFFFFFFFFL;
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Comparator.class, PinInfo.input("a"), PinInfo.input("b")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.BITS).addAttribute(Keys.SIGNED).setShortName("").supportsHDL();
    private final int bits;
    private final Boolean signed;
    private final ObservableValue aklb;
    private final ObservableValue equals;
    private final ObservableValue agrb;
    private ObservableValue a;
    private ObservableValue b;
    private long valueA;
    private long valueB;

    public Comparator(ElementAttributes attributes) {
        this.signed = attributes.get(Keys.SIGNED);
        this.bits = attributes.get(Keys.BITS);
        this.agrb = new ObservableValue(">", 1).setPinDescription(DESCRIPTION);
        this.equals = new ObservableValue("=", 1).setPinDescription(DESCRIPTION);
        this.aklb = new ObservableValue("<", 1).setPinDescription(DESCRIPTION);
    }

    @Override
    public void readInputs() throws NodeException {
        if (this.signed.booleanValue()) {
            this.valueA = this.a.getValueSigned();
            this.valueB = this.b.getValueSigned();
        } else {
            this.valueA = this.a.getValue();
            this.valueB = this.b.getValue();
        }
    }

    @Override
    public void writeOutputs() throws NodeException {
        if (this.valueA == this.valueB) {
            this.equals.setValue(1L);
            this.aklb.setValue(0L);
            this.agrb.setValue(0L);
        } else {
            boolean kl;
            this.equals.setValue(0L);
            if (this.bits < 64 || this.signed.booleanValue()) {
                kl = this.valueA < this.valueB;
            } else {
                boolean b;
                boolean a = (this.valueA & MSB) != 0L;
                boolean bl = b = (this.valueB & MSB) != 0L;
                kl = a == b ? (this.valueA & LSB) < (this.valueB & LSB) : a < b;
            }
            this.aklb.setBool(kl);
            this.agrb.setBool(!kl);
        }
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.a = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this, 0);
        this.b = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(this.bits, this, 1);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.ovs(this.agrb, this.equals, this.aklb);
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }
}

