/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.NodeWithoutDelay;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.lang.Lang;

public class BitExtender
implements Element {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(BitExtender.class, PinInfo.input("in")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.INPUT_BITS).addAttribute(Keys.OUTPUT_BITS).supportsHDL();
    private final ObservableValue out;
    private final int outBits;
    private final int inBits;
    private NodeWithoutDelay node;

    public BitExtender(ElementAttributes attr) {
        this.outBits = attr.get(Keys.OUTPUT_BITS);
        this.out = new ObservableValue("out", this.outBits).setPinDescription(DESCRIPTION);
        this.inBits = attr.get(Keys.INPUT_BITS);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws NodeException {
        final ObservableValue in = ((ObservableValue)inputs.get(0)).checkBits(this.inBits, null);
        if (this.inBits >= this.outBits) {
            throw new NodeException(Lang.get("err_notMoreOutBitsThanInBits", new Object[0]), new ObservableValue[0]);
        }
        final long signMask = Bits.signedFlagMask(this.inBits);
        final long extendMask = Bits.mask(this.inBits) ^ 0xFFFFFFFFFFFFFFFFL;
        this.node = new NodeWithoutDelay(new ObservableValue[]{this.out}){

            @Override
            public void hasChanged() {
                long inValue = in.getValue();
                if ((inValue & signMask) == 0L) {
                    BitExtender.this.out.setValue(inValue);
                } else {
                    BitExtender.this.out.setValue(inValue | extendMask);
                }
            }
        };
        in.addObserver(this.node);
    }

    @Override
    public void init(Model model) throws NodeException {
        this.node.hasChanged();
    }

    @Override
    public ObservableValues getOutputs() {
        return this.out.asList();
    }

    @Override
    public void registerNodes(Model model) {
    }
}

