/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core.arithmetic;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.element.Element;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinInfo;
import de.neemann.digital.core.stats.Countable;

public class Add
extends Node
implements Element,
Countable {
    public static final ElementTypeDescription DESCRIPTION = new ElementTypeDescription(Add.class, PinInfo.input("a"), PinInfo.input("b"), PinInfo.input("c_i")).addAttribute(Keys.ROTATE).addAttribute(Keys.LABEL).addAttribute(Keys.BITS).supportsHDL();
    private final int bits;
    private final ObservableValue sum;
    private final ObservableValue cOut;
    private ObservableValue a;
    private ObservableValue b;
    private ObservableValue cIn;
    private Calc calc;
    private long aVal;
    private long bVal;
    private long cVal;
    private static final long LOWMASK = Long.MAX_VALUE;
    private static final long CARRYMASK = Long.MIN_VALUE;

    public Add(ElementAttributes attributes) {
        this.bits = attributes.get(Keys.BITS);
        this.sum = new ObservableValue("s", this.bits).setPinDescription(DESCRIPTION);
        this.cOut = new ObservableValue("c_o", 1).setPinDescription(DESCRIPTION);
        this.calc = this.createCalculation(this.bits);
    }

    Calc createCalculation(int bits) {
        if (bits < 64) {
            long mask = Bits.up(1L, bits);
            return (a, b, ci, s, co) -> {
                long value = a + b + ci;
                s.setValue(value);
                co.setBool((value & mask) != 0L);
            };
        }
        return (a, b, ci, s, co) -> {
            long sum = a + b;
            s.setValue(sum + ci);
            co.setBool(Add.addCarry(a, b) | Add.addCarry(sum, ci));
        };
    }

    private static boolean addCarry(long x, long y) {
        boolean c = ((x & Long.MAX_VALUE) + (y & Long.MAX_VALUE) & Long.MIN_VALUE) != 0L;
        boolean a = (x & Long.MIN_VALUE) != 0L;
        boolean b = (y & Long.MIN_VALUE) != 0L;
        return a & b | (a ^ b) & c;
    }

    @Override
    public void readInputs() throws NodeException {
        this.aVal = this.a.getValue();
        this.bVal = this.b.getValue();
        this.cVal = this.cIn.getValue();
    }

    @Override
    public void writeOutputs() throws NodeException {
        this.calc.calc(this.aVal, this.bVal, this.cVal, this.sum, this.cOut);
    }

    @Override
    public void setInputs(ObservableValues inputs) throws BitsException {
        this.a = ((ObservableValue)inputs.get(0)).addObserverToValue(this).checkBits(this.bits, this, 0);
        this.b = ((ObservableValue)inputs.get(1)).addObserverToValue(this).checkBits(this.bits, this, 1);
        this.cIn = ((ObservableValue)inputs.get(2)).addObserverToValue(this).checkBits(1, this, 2);
    }

    @Override
    public ObservableValues getOutputs() {
        return ObservableValues.ovs(this.sum, this.cOut);
    }

    @Override
    public int getDataBits() {
        return this.bits;
    }

    static interface Calc {
        public void calc(long var1, long var3, long var5, ObservableValue var7, ObservableValue var8);
    }
}

