/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.io.InValue;

public class Value {
    private final long value;
    private final long highZ;
    private final int bits;
    private final long mask;

    public Value(int bits) {
        this.bits = bits;
        this.mask = Bits.mask(bits);
        this.value = 0L;
        this.highZ = this.mask;
    }

    public Value(long value, int bits) {
        this.bits = bits;
        this.mask = Bits.mask(bits);
        this.value = value & this.mask;
        this.highZ = 0L;
    }

    public Value(InValue value, int bits) {
        this.bits = bits;
        this.mask = Bits.mask(bits);
        if (value.isHighZ()) {
            this.value = 0L;
            this.highZ = this.mask;
        } else {
            this.value = value.getValue() & this.mask;
            this.highZ = 0L;
        }
    }

    Value(ObservableValue observableValue) {
        this.value = observableValue.getValue();
        this.highZ = observableValue.getHighZ();
        this.bits = observableValue.getBits();
        this.mask = Bits.mask(this.bits);
    }

    public boolean isHighZ() {
        return this.highZ != 0L;
    }

    public long getValue() {
        return this.value;
    }

    public long getValueSigned() {
        return Bits.signExtend(this.value, this.bits);
    }

    public boolean getBool() {
        return this.value != 0L;
    }

    public int getBits() {
        return this.bits;
    }

    public String toString() {
        if (this.highZ != 0L) {
            if (this.highZ == this.mask) {
                return "Z";
            }
            return ObservableValue.zMaskString(this.value, this.highZ, this.bits);
        }
        return IntFormat.toShortHex(this.value);
    }

    public boolean isEqual(Value other) {
        if (this.highZ != other.highZ) {
            return false;
        }
        long m = this.highZ ^ 0xFFFFFFFFFFFFFFFFL;
        return (this.value & m) == (other.value & m);
    }

    public void applyTo(ObservableValue val) {
        val.set(this.value, this.highZ);
    }
}

