/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.BitsException;
import de.neemann.digital.core.IntFormat;
import de.neemann.digital.core.Node;
import de.neemann.digital.core.Observable;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.Value;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.lang.Lang;
import java.util.Random;

public class ObservableValue
extends Observable
implements PinDescription {
    private final String name;
    private final long mask;
    private final long signedFlag;
    private final int bits;
    private long value;
    private long highZ;
    private boolean bidirectional;
    private boolean isConstant = false;
    private String description;
    private String pinNumber;
    private boolean isSwitchPin;
    private Random random;

    public ObservableValue(String name, int bits) {
        this.name = name;
        this.bits = bits;
        this.mask = Bits.mask(bits);
        this.signedFlag = Bits.signedFlagMask(bits);
    }

    public ObservableValue setConstant() {
        this.isConstant = true;
        return this;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public ObservableValue setValue(long value) {
        return this.set(value, 0L);
    }

    public ObservableValue setToHighZ() {
        return this.set(0L, -1L);
    }

    public ObservableValue set(long value, long highZ) {
        value = this.getValueBits(value);
        if ((highZ = this.getValueBits(highZ)) != this.highZ || ((highZ ^ 0xFFFFFFFFFFFFFFFFL) & (value ^ this.value)) != 0L) {
            if (this.isConstant) {
                throw new RuntimeException("tried to modify a constant value!");
            }
            this.highZ = highZ;
            this.value = value & (highZ ^ 0xFFFFFFFFFFFFFFFFL);
            this.fireHasChanged();
        }
        return this;
    }

    public ObservableValue addObserverToValue(Observer observer) {
        this.addObserver(observer);
        return this;
    }

    public int getBits() {
        return this.bits;
    }

    public long getValue() {
        if (this.highZ != 0L) {
            if (this.random == null) {
                this.random = new Random();
            }
            return this.value | this.random.nextLong() & this.highZ;
        }
        return this.value;
    }

    public long getValueHighZIsZero() {
        return this.value;
    }

    public long getHighZ() {
        return this.highZ;
    }

    public String getValueString() {
        if (this.highZ != 0L) {
            if (this.highZ == this.mask) {
                return "Z";
            }
            return ObservableValue.zMaskString(this.value, this.highZ, this.bits);
        }
        return IntFormat.toShortHex(this.value);
    }

    static String zMaskString(long value, long highZ, int bits) {
        StringBuilder sb = new StringBuilder();
        long m = Bits.up(1L, bits - 1);
        for (int i = 0; i < bits; ++i) {
            if ((highZ & m) != 0L) {
                sb.append("z");
            } else if ((value & m) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            m >>>= 1;
        }
        return sb.toString();
    }

    public long getValueSigned() {
        long v = this.getValue();
        if ((v & this.signedFlag) != 0L) {
            v |= this.mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return v;
    }

    public boolean getBool() {
        return this.getValue() != 0L;
    }

    public void setBool(boolean bool) {
        if (bool) {
            this.setValue(1L);
        } else {
            this.setValue(0L);
        }
    }

    public long getValueBits(long value) {
        return value & this.mask;
    }

    public ObservableValue checkBits(int bits, Node node) throws BitsException {
        return this.checkBits(bits, node, -1);
    }

    public ObservableValue checkBits(int bits, Node node, int input) throws BitsException {
        if (this.bits != bits) {
            throw new BitsException(Lang.get("err_needs_N0_bits_found_N2_bits", bits, this.bits), node, input, this);
        }
        return this;
    }

    public boolean isHighZ() {
        return this.highZ != 0L;
    }

    public String toString() {
        return this.name + "{value=" + this.getValueString() + ", setBits=" + this.bits + '}';
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ObservableValue setBidirectional() {
        this.bidirectional = true;
        return this;
    }

    @Override
    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getName();
    }

    public ObservableValue setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public PinDescription.Direction getDirection() {
        if (this.bidirectional) {
            return PinDescription.Direction.both;
        }
        return PinDescription.Direction.output;
    }

    public ObservableValues asList() {
        return new ObservableValues(this);
    }

    public ObservableValue setPinDescription(ElementTypeDescription description) {
        this.setDescription(Lang.get(description.getPinLangKey() + this.name, new Object[0]));
        return this;
    }

    @Override
    public String getPinNumber() {
        return this.pinNumber;
    }

    @Override
    public boolean isClock() {
        return false;
    }

    @Override
    public boolean isSwitchPin() {
        return this.isSwitchPin;
    }

    public ObservableValue setSwitchPin(boolean switchPin) {
        this.isSwitchPin = switchPin;
        return this;
    }

    public ObservableValue setPinNumber(String pinNumber) {
        this.pinNumber = pinNumber;
        return this;
    }

    public Value getCopy() {
        return new Value(this);
    }
}

