/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.ObservableValue;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GlobalValues {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalValues.class);
    private static GlobalValues ourInstance = new GlobalValues();
    private ArrayList<GlobalValueListener> listeners = new ArrayList();

    public static GlobalValues getInstance() {
        return ourInstance;
    }

    private GlobalValues() {
    }

    public void register(String name, ObservableValue value, Model model) {
        for (GlobalValueListener l : this.listeners) {
            l.valueCreated(name, value, model);
        }
    }

    public void addListener(GlobalValueListener listener) {
        this.listeners.add(listener);
        LOGGER.debug("global value listener added " + this.listeners.size());
    }

    public void removeListener(GlobalValueListener listener) {
        this.listeners.remove(listener);
        LOGGER.debug("global value listener removed " + this.listeners.size());
    }

    public static interface GlobalValueListener {
        public void valueCreated(String var1, ObservableValue var2, Model var3);
    }
}

