/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.core;

import de.neemann.digital.lang.Lang;

public final class Bits {
    private Bits() {
    }

    public static long up(long val, int bits) {
        if (bits < 64) {
            return val << bits;
        }
        return 0L;
    }

    public static long down(long val, int bits) {
        if (bits < 64) {
            return val >>> bits;
        }
        return 0L;
    }

    public static long mask(int bits) {
        if (bits < 64) {
            return (1L << bits) - 1L;
        }
        return -1L;
    }

    public static long signedFlagMask(int bits) {
        return Bits.up(1L, bits - 1);
    }

    public static boolean isNegative(long value, int bits) {
        return (value & Bits.signedFlagMask(bits)) != 0L;
    }

    public static long signExtend(long value, int bits) {
        if (bits >= 64) {
            return value;
        }
        if ((value & Bits.signedFlagMask(bits)) == 0L) {
            return value;
        }
        return value | Bits.mask(bits) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static int binLn2(long b) {
        int outBits = 1;
        while (1L << outBits <= b) {
            ++outBits;
        }
        return outBits;
    }

    public static int removeBitFromValue(int value, int bit) {
        if (bit > 0) {
            return (value & ~((1 << bit + 1) - 1)) >>> 1 | value & (1 << bit) - 1;
        }
        return value >>> 1;
    }

    public static long decode(String str) throws NumberFormatException {
        return Bits.decode(str, false);
    }

    public static long decode(String str, boolean parseFloats) throws NumberFormatException {
        int radix;
        boolean neg;
        int p;
        block23: {
            block22: {
                if (str == null) {
                    return 0L;
                }
                if ((str = str.trim()).length() == 0) {
                    return 0L;
                }
                if (str.indexOf(58) >= 0) {
                    return Bits.decodeFixed(str);
                }
                if (parseFloats && str.indexOf(46) > -1) {
                    try {
                        if (str.endsWith("d") || str.endsWith("D")) {
                            return Double.doubleToLongBits(Double.parseDouble(str.substring(0, str.length() - 1)));
                        }
                        return Float.floatToIntBits(Float.parseFloat(str));
                    }
                    catch (java.lang.NumberFormatException e) {
                        throw new NumberFormatException(str, 0);
                    }
                }
                p = 0;
                neg = false;
                if (str.charAt(p) == '-') {
                    neg = true;
                    ++p;
                }
                if (p >= str.length()) {
                    throw new NumberFormatException(str, p);
                }
                boolean wasZero = false;
                while (str.length() > p && str.charAt(p) == '0') {
                    wasZero = true;
                    ++p;
                }
                if (p >= str.length()) {
                    return 0L;
                }
                if (!wasZero) break block22;
                if (neg) {
                    throw new NumberFormatException(str, p);
                }
                switch (str.charAt(p)) {
                    case 'X': 
                    case 'x': {
                        radix = 16;
                        if (++p == str.length()) {
                            throw new NumberFormatException(str, p);
                        }
                        break block23;
                    }
                    case 'B': 
                    case 'b': {
                        radix = 2;
                        if (++p == str.length()) {
                            throw new NumberFormatException(str, p);
                        }
                        break block23;
                    }
                    default: {
                        radix = 8;
                        break;
                    }
                }
                break block23;
            }
            if (str.charAt(p) == '\'') {
                if (neg) {
                    throw new NumberFormatException(str, p);
                }
                if (++p == str.length()) {
                    throw new NumberFormatException(str, p);
                }
                return str.charAt(p);
            }
            radix = 10;
        }
        long val = Bits.decode(str, p, radix);
        if (neg) {
            val = -val;
        }
        return val;
    }

    public static long decode(String str, int p, int radix) throws NumberFormatException {
        long val = 0L;
        while (p < str.length()) {
            int d = Character.digit(str.charAt(p), radix);
            if (d < 0) {
                throw new NumberFormatException(str, p);
            }
            val = val * (long)radix + (long)d;
            ++p;
        }
        return val;
    }

    private static long decodeFixed(String str) throws NumberFormatException {
        int p = str.indexOf(58);
        try {
            int frac = Math.abs(Integer.parseInt(str.substring(p + 1)));
            double floating = Double.parseDouble(str.substring(0, p));
            return Math.round(floating * (double)(1L << frac));
        }
        catch (java.lang.NumberFormatException e) {
            throw new NumberFormatException(str, 0);
        }
    }

    public static final class NumberFormatException
    extends Exception {
        private NumberFormatException(String str, int p) {
            super(Lang.get("err_invalidNumberFormat_N_N", str, p + 1));
        }
    }
}

