/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli.cli;

import java.io.PrintStream;

public class CLIException
extends Exception {
    private final int exitCode;
    private boolean showHelp = true;

    public CLIException(String message, int exitCode) {
        super(message);
        this.exitCode = exitCode;
    }

    public CLIException(String message, Throwable cause) {
        super(message, cause);
        this.exitCode = 200;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void printMessage(PrintStream out) {
        out.println(this.getMessage());
        Throwable c = this.getCause();
        if (c != null) {
            if (c instanceof CLIException) {
                ((CLIException)c).printMessage(out);
            } else {
                out.println(c.getMessage());
            }
        }
    }

    public CLIException hideHelp() {
        this.showHelp = false;
        return this;
    }

    public boolean showHelp() {
        return this.showHelp;
    }
}

