/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli.cli;

import de.neemann.digital.cli.cli.Argument;
import de.neemann.digital.cli.cli.ArgumentBase;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Key;

public class ArgumentKey<T>
extends ArgumentBase<T> {
    private final Key<T> key;
    private final ElementAttributes attr;
    private final String name;

    public ArgumentKey(Key<T> key, ElementAttributes attr) {
        this(key, attr, 0);
    }

    public ArgumentKey(Key<T> key, ElementAttributes attr, int stripFromKey) {
        this.key = key;
        this.attr = attr;
        this.name = stripFromKey > 0 ? this.key.getKey().substring(stripFromKey) : this.key.getKey();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isOptional() {
        return true;
    }

    @Override
    public void setString(String val) throws CLIException {
        this.attr.set(this.key, Argument.fromString(val, this.key.getDefault()));
    }

    @Override
    public boolean isSet() {
        return this.attr.contains(this.key);
    }

    @Override
    public String getDescription(String command) {
        return this.key.getDescription();
    }

    @Override
    public T get() {
        return this.attr.get(this.key);
    }
}

