/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli;

import de.neemann.digital.cli.CSVWriter;
import de.neemann.digital.cli.CircuitLoader;
import de.neemann.digital.cli.cli.Argument;
import de.neemann.digital.cli.cli.BasicCommand;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.core.stats.Statistics;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.lang.Lang;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class StatsExport
extends BasicCommand {
    private final Argument<String> digFile = this.addArgument(new Argument<String>("dig", "", false));
    private final Argument<String> csvFile = this.addArgument(new Argument<String>("csv", "", true));

    public StatsExport() {
        super("stats");
    }

    @Override
    protected void execute() throws CLIException {
        try {
            Model model = new CircuitLoader(this.digFile.get()).createModel();
            Statistics stats = new Statistics(model);
            BufferedWriter writer = this.csvFile.isSet() ? new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.csvFile.get()))) : new BufferedWriter(new OutputStreamWriter(System.out));
            new CSVWriter(stats.getTableModel()).writeTo(writer);
        }
        catch (NodeException | PinException | ElementNotFoundException | IOException e) {
            throw new CLIException(Lang.get("cli_errorCreatingStats", new Object[0]), e);
        }
    }
}

