/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli;

import de.neemann.digital.FileLocator;
import de.neemann.digital.cli.CircuitLoader;
import de.neemann.digital.cli.cli.Argument;
import de.neemann.digital.cli.cli.BasicCommand;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.core.Model;
import de.neemann.digital.core.ModelEventType;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.wiring.Clock;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.model.RealTimeClock;
import de.neemann.digital.gui.ProgramMemoryLoader;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runner
extends BasicCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(Runner.class);
    private final Argument<String> digFile = this.addArgument(new Argument<String>("dig", "", false));

    public Runner() {
        super("run");
    }

    @Override
    protected void execute() throws CLIException {
        try {
            CircuitLoader circuitLoader = new CircuitLoader(this.digFile.get(), false);
            Circuit circuit = circuitLoader.getCircuit();
            long time = System.currentTimeMillis();
            ModelCreator modelCreator = new ModelCreator(circuit, circuitLoader.getLibrary());
            Model model = modelCreator.createModel(true);
            time = System.currentTimeMillis() - time;
            LOGGER.debug("model creation: " + time + " ms, " + model.getNodes().size() + " nodes");
            ArrayList<Clock> clocks = model.getClocks();
            if (clocks.size() == 0) {
                throw new CLIException(Lang.get("cli_run_noClock", new Object[0]), null);
            }
            ScheduledThreadPoolExecutor timerExecutor = new ScheduledThreadPoolExecutor(1);
            int threadRunnerCount = 0;
            boolean realTimeClockRunning = false;
            for (Clock c : clocks) {
                int frequency = c.getFrequency();
                if (frequency <= 0) continue;
                RealTimeClock realTimeClock = new RealTimeClock(model, c, timerExecutor, null);
                if (realTimeClock.isThreadRunner()) {
                    ++threadRunnerCount;
                }
                realTimeClockRunning = true;
            }
            if (threadRunnerCount > 1) {
                throw new CLIException(Lang.get("err_moreThanOneFastClock", new Object[0]), null);
            }
            if (!realTimeClockRunning) {
                throw new CLIException(Lang.get("cli_run_noClock", new Object[0]), null);
            }
            ElementAttributes settings = circuit.getAttributes();
            if (settings.get(Keys.PRELOAD_PROGRAM).booleanValue()) {
                File romHex = new FileLocator(settings.get(Keys.PROGRAM_TO_PRELOAD)).setBaseFile(new File(this.digFile.get())).locate();
                new ProgramMemoryLoader(romHex, settings.get(Keys.BIG_ENDIAN_SETTING)).preInit(model);
            }
            model.addObserver(event -> {
                if (event.getType() == ModelEventType.POSTCLOSED) {
                    timerExecutor.shutdownNow();
                }
            }, ModelEventType.POSTCLOSED, new ModelEventType[0]);
            model.init();
        }
        catch (Exception e) {
            throw new CLIException(Lang.get("cli_errorRunningCircuit", new Object[0]), e);
        }
    }
}

