/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli;

import de.neemann.digital.cli.CircuitLoader;
import de.neemann.digital.cli.cli.Argument;
import de.neemann.digital.cli.cli.BasicCommand;
import de.neemann.digital.cli.cli.CLIException;
import de.neemann.digital.core.ErrorDetector;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestExecutor;
import de.neemann.digital.testing.TestResult;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class CommandLineTester {
    private final CircuitLoader circuitLoader;
    private List<Circuit.TestCase> testCases;
    private int testsPassed;
    private boolean allowMissingInputs;
    private boolean verbose;

    public CommandLineTester(File file) throws IOException {
        this.circuitLoader = new CircuitLoader(file);
    }

    public CommandLineTester useTestCasesFrom(File file) throws IOException {
        Circuit c = Circuit.loadCircuit(file, this.circuitLoader.getShapeFactory());
        this.testCases = c.getTestCases();
        return this;
    }

    public int execute(PrintStream out) {
        if (this.testCases == null) {
            this.testCases = this.circuitLoader.getCircuit().getTestCases();
        }
        int errorCount = 0;
        if (this.testCases.isEmpty()) {
            out.println("no test cases given");
            ++errorCount;
        } else {
            for (Circuit.TestCase t : this.testCases) {
                String label = t.getLabel();
                if (label.isEmpty()) {
                    label = "unnamed";
                }
                try {
                    ErrorDetector errorDetector = new ErrorDetector();
                    TestResult tr = new TestExecutor(t, this.circuitLoader.getCircuit(), this.circuitLoader.getLibrary()).setAllowMissingInputs(this.allowMissingInputs).addObserver(errorDetector).execute();
                    if (tr.allPassed()) {
                        out.println(label + ": passed");
                        ++this.testsPassed;
                    } else {
                        String message = label + ": failed";
                        message = tr.isErrorOccurred() ? message + " due to an error" : message + " (" + tr.failedPercent() + "%)";
                        out.println(message);
                        if (this.verbose) {
                            out.println(tr.getValueTable());
                        }
                        ++errorCount;
                    }
                    errorDetector.check();
                }
                catch (Exception e) {
                    out.println(label + ": " + e.getMessage());
                    ++errorCount;
                }
            }
        }
        return errorCount;
    }

    public int getTestsPassed() {
        return this.testsPassed;
    }

    private CommandLineTester setAllowMissingInputs(boolean allowMissingInputs) {
        this.allowMissingInputs = allowMissingInputs;
        return this;
    }

    public CommandLineTester setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public static class TestCommand
    extends BasicCommand {
        private final Argument<String> circ = this.addArgument(new Argument<String>("circ", "", false));
        private final Argument<String> tests = this.addArgument(new Argument<String>("tests", "", true));
        private final Argument<Boolean> allowMissingInputs = this.addArgument(new Argument<Boolean>("allowMissingInputs", false, true));
        private final Argument<Boolean> verbose = this.addArgument(new Argument<Boolean>("verbose", false, true));
        private int testsPassed;

        public TestCommand() {
            super("test");
        }

        @Override
        protected void execute() throws CLIException {
            try {
                CommandLineTester clt = new CommandLineTester(new File(this.circ.get())).setVerbose(this.verbose.get()).setAllowMissingInputs(this.allowMissingInputs.get());
                if (this.tests.isSet()) {
                    clt.useTestCasesFrom(new File(this.tests.get()));
                }
                int errors = clt.execute(System.out);
                this.testsPassed = clt.getTestsPassed();
                if (errors > 0) {
                    throw new CLIException(Lang.get("cli_thereAreTestFailures", new Object[0]), errors).hideHelp();
                }
            }
            catch (IOException e) {
                throw new CLIException(Lang.get("cli_errorExecutingTests", new Object[0]), e);
            }
        }

        public int getTestsPassed() {
            return this.testsPassed;
        }
    }
}

