/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.cli;

import de.neemann.digital.core.Model;
import de.neemann.digital.core.NodeException;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.model.ModelCreator;
import de.neemann.digital.draw.shapes.ShapeFactory;
import java.io.File;
import java.io.IOException;

public final class CircuitLoader {
    private final Circuit circuit;
    private final ElementLibrary library = new ElementLibrary();
    private final ShapeFactory shapeFactory;

    public CircuitLoader(String filename) throws IOException {
        this(new File(filename), true);
    }

    public CircuitLoader(String filename, boolean ieeeShapes) throws IOException {
        this(new File(filename), ieeeShapes);
    }

    public CircuitLoader(File file) throws IOException {
        this(file, true);
    }

    public CircuitLoader(File file, boolean ieeeShapes) throws IOException {
        this.library.setRootFilePath(file.getAbsoluteFile().getParentFile());
        this.shapeFactory = new ShapeFactory(this.library, ieeeShapes);
        this.circuit = Circuit.loadCircuit(file, this.shapeFactory);
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public ElementLibrary getLibrary() {
        return this.library;
    }

    public ShapeFactory getShapeFactory() {
        return this.shapeFactory;
    }

    public Model createModel() throws ElementNotFoundException, PinException, NodeException {
        return new ModelCreator(this.circuit, this.library).createModel(false);
    }
}

