/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.tt2;

import de.neemann.digital.builder.tt2.RotationByteArrayOutputStream;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OSExecute {
    private final ProcessBuilder processBuilder;
    private int timeOutSec = 30;
    private Process process;
    private boolean ignoreReturnCode = false;

    public OSExecute(String ... args) {
        this.processBuilder = new ProcessBuilder(args);
    }

    public OSExecute(List<String> args) {
        this.processBuilder = new ProcessBuilder(args);
    }

    public OSExecute setWorkingDir(File workingDir) {
        this.processBuilder.directory(workingDir);
        return this;
    }

    public OSExecute setEnvVar(String key, String value) {
        this.processBuilder.environment().put(key, value);
        return this;
    }

    public OSExecute setTimeOutSec(int timeOutSec) {
        if (timeOutSec == 0) {
            timeOutSec = Integer.MAX_VALUE;
        }
        this.timeOutSec = timeOutSec;
        return this;
    }

    public String startAndWait() throws IOException {
        this.processBuilder.redirectErrorStream(true);
        this.process = this.processBuilder.start();
        InputStream console = this.process.getInputStream();
        StreamReader consoleReader = new StreamReader(console);
        consoleReader.start();
        try {
            this.process.waitFor(this.timeOutSec, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.process.isAlive()) {
            this.process.destroy();
            consoleReader.interrupt();
            throw new IOException(Lang.get("err_processDoesNotTerminate_N", this.processBuilder.command()));
        }
        try {
            consoleReader.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.process.exitValue() != 0 && !this.ignoreReturnCode) {
            throw new IOException(Lang.get("err_processExitedWithError_N1_N2", this.process.exitValue(), "\n" + consoleReader.toString()));
        }
        if (consoleReader.getException() != null) {
            throw consoleReader.getException();
        }
        return consoleReader.toString();
    }

    public void terminate() {
        if (this.process.isAlive()) {
            this.ignoreReturnCode = true;
            this.process.destroy();
        }
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    public OSExecute startInThread(ProcessCallback callback) {
        new WaitThread(this, callback).start();
        return this;
    }

    public static interface ProcessCallback {
        public void processTerminated(String var1);

        public void exception(Exception var1);
    }

    private static final class WaitThread
    extends Thread {
        private final OSExecute os;
        private final ProcessCallback callback;

        private WaitThread(OSExecute os, ProcessCallback callback) {
            this.os = os;
            this.callback = callback;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block3: {
                try {
                    String result = this.os.startAndWait();
                    if (this.callback != null) {
                        this.callback.processTerminated(result);
                    }
                }
                catch (Exception e) {
                    if (this.callback == null) break block3;
                    this.callback.exception(e);
                }
            }
        }
    }

    private static final class StreamReader
    extends Thread {
        private final InputStream console;
        private final RotationByteArrayOutputStream baos;
        private IOException exception;

        private StreamReader(InputStream console) {
            this.console = console;
            this.baos = new RotationByteArrayOutputStream(20480);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                int l;
                byte[] data = new byte[4096];
                while ((l = this.console.read(data)) >= 0) {
                    RotationByteArrayOutputStream rotationByteArrayOutputStream = this.baos;
                    synchronized (rotationByteArrayOutputStream) {
                        this.baos.write(data, 0, l);
                    }
                }
                return;
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        private IOException getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            RotationByteArrayOutputStream rotationByteArrayOutputStream = this.baos;
            synchronized (rotationByteArrayOutputStream) {
                return this.baos.toString();
            }
        }
    }
}

