/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.jedec;

import de.neemann.digital.builder.jedec.FuseMap;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class JedecWriter
extends FilterOutputStream {
    private static final int LINELEN = 32;
    private static final String LINEEND = "\r\n";
    private static final int STX = 2;
    private static final int ETX = 3;
    private int checksum;

    public JedecWriter(OutputStream out) throws IOException {
        super(out);
        this.write(2);
    }

    public JedecWriter print(String s) throws IOException {
        this.write(s.getBytes(StandardCharsets.ISO_8859_1));
        return this;
    }

    public JedecWriter println(String s) throws IOException {
        this.print(s);
        this.print(LINEEND);
        return this;
    }

    public JedecWriter write(FuseMap fuseMap) throws IOException {
        this.println("QF" + fuseMap.getFuses() + "*");
        this.println("G0*");
        this.println("F0*");
        int lines = (fuseMap.getFuses() - 1) / 32 + 1;
        for (int li = 0; li < lines; ++li) {
            int pos = li * 32;
            int len = 32;
            if (pos + len > fuseMap.getFuses()) {
                len = fuseMap.getFuses() - pos;
            }
            boolean containsOne = false;
            StringBuilder sb = new StringBuilder();
            sb.append("L").append(pos).append(" ");
            for (int i = 0; i < len; ++i) {
                if (fuseMap.getFuse(pos + i)) {
                    sb.append("1");
                    containsOne = true;
                    continue;
                }
                sb.append("0");
            }
            if (!containsOne) continue;
            this.print(sb.toString());
            this.print("*");
            this.print(LINEEND);
        }
        this.println("C" + this.toHex(fuseMap.getJedecChecksum(), 4) + "*");
        return this;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.checksum += b & 0x7F;
    }

    @Override
    public void close() throws IOException {
        this.write(3);
        this.out.write(this.toHex(this.checksum & 0xFFFF, 4).getBytes(StandardCharsets.ISO_8859_1));
        super.close();
    }

    private String toHex(int checksum, int s) {
        String h = Integer.toHexString(checksum).toUpperCase();
        while (h.length() < 4) {
            h = "0" + h;
        }
        return h;
    }

    int getChecksum() {
        return this.checksum;
    }
}

