/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.circuit;

import de.neemann.digital.builder.circuit.Box;
import de.neemann.digital.builder.circuit.Fragment;
import de.neemann.digital.builder.circuit.FragmentVisitor;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.PinDescription;
import de.neemann.digital.core.flipflops.FlipflopD;
import de.neemann.digital.core.flipflops.FlipflopJK;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.Pin;
import de.neemann.digital.draw.elements.Pins;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.graphics.GraphicMinMax;
import de.neemann.digital.draw.graphics.Vector;
import de.neemann.digital.draw.shapes.ShapeFactory;
import java.util.ArrayList;
import java.util.List;

public class FragmentVisualElement
implements Fragment {
    private ArrayList<Vector> inputs;
    private ArrayList<Vector> outputs;
    private VisualElement visualElement;
    private Vector pos;

    public FragmentVisualElement(ElementTypeDescription description, ShapeFactory shapeFactory) {
        this(description, 1, shapeFactory);
    }

    public FragmentVisualElement(ElementTypeDescription description, int inputCount, ShapeFactory shapeFactory) {
        this.visualElement = new VisualElement(description.getName()).setShapeFactory(shapeFactory);
        this.visualElement.getElementAttributes().set(Keys.INPUT_COUNT, inputCount);
    }

    private void checkInOutPresent() {
        if (this.inputs == null || this.outputs == null) {
            Pins pins = this.visualElement.getShape().getPins();
            this.inputs = new ArrayList();
            this.outputs = new ArrayList();
            for (Pin p : pins) {
                if (p.getDirection().equals((Object)PinDescription.Direction.input)) {
                    this.inputs.add(p.getPos());
                    continue;
                }
                this.outputs.add(p.getPos());
            }
        }
    }

    public FragmentVisualElement ignoreInput(int n) {
        this.checkInOutPresent();
        this.inputs.remove(n);
        return this;
    }

    public <VALUE> FragmentVisualElement setAttr(Key<VALUE> key, VALUE value) {
        this.visualElement.getElementAttributes().set(key, value);
        return this;
    }

    @Override
    public Box doLayout() {
        this.checkInOutPresent();
        GraphicMinMax mm = new GraphicMinMax();
        for (Vector p : this.inputs) {
            mm.check(p);
        }
        for (Vector p : this.outputs) {
            mm.check(p);
        }
        Vector delta = mm.getMax().sub(mm.getMin());
        if (this.visualElement.equalsDescription(FlipflopJK.DESCRIPTION) || this.visualElement.equalsDescription(FlipflopD.DESCRIPTION)) {
            return new Box(delta.x, delta.y + 20);
        }
        return new Box(delta.x, delta.y);
    }

    @Override
    public void setPos(Vector pos) {
        this.pos = pos;
    }

    @Override
    public void addToCircuit(Vector offset, Circuit circuit) {
        this.visualElement.setPos(this.pos.add(offset));
        circuit.add(this.visualElement);
    }

    @Override
    public List<Vector> getInputs() {
        this.checkInOutPresent();
        return Vector.add(this.inputs, this.pos);
    }

    @Override
    public List<Vector> getOutputs() {
        this.checkInOutPresent();
        return Vector.add(this.outputs, this.pos);
    }

    public VisualElement getVisualElement() {
        return this.visualElement;
    }

    public void setVisualElement(VisualElement visualElement) {
        this.visualElement = visualElement;
    }

    @Override
    public <V extends FragmentVisitor> V traverse(V v) {
        v.visit(this);
        return v;
    }
}

