/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.Gal16v8;

import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.builder.BuilderCollector;
import de.neemann.digital.builder.ExpressionExporter;
import de.neemann.digital.builder.Gal16v8.BuilderCollectorGAL;
import de.neemann.digital.builder.PinMap;
import de.neemann.digital.builder.PinMapException;
import de.neemann.digital.builder.jedec.FuseMap;
import de.neemann.digital.builder.jedec.FuseMapFiller;
import de.neemann.digital.builder.jedec.FuseMapFillerException;
import de.neemann.digital.builder.jedec.JedecWriter;
import java.io.IOException;
import java.io.OutputStream;

public class Gal16v8JEDECExporter
implements ExpressionExporter<Gal16v8JEDECExporter> {
    private static final int SIG = 2056;
    private static final int SYN = 2192;
    private static final int AC0 = 2193;
    private static final int PTD_START = 2128;
    private static final int PTD_END = 2191;
    private static final int XOR = 2048;
    private static final int AC1 = 2120;
    private final FuseMap map = new FuseMap(2194);
    private final FuseMapFiller filler;
    private final BuilderCollector builder;
    private final PinMap pinMap;

    public Gal16v8JEDECExporter() {
        for (int i = 2128; i <= 2191; ++i) {
            this.map.setFuse(i, true);
        }
        this.filler = new FuseMapFiller(this.map, 16);
        this.pinMap = new PinMap().setAvailInputs(2, 3, 4, 5, 6, 7, 8, 9).setAvailOutputs(12, 13, 14, 15, 16, 17, 18, 19);
        this.builder = new BuilderCollectorGAL(this.pinMap);
    }

    private void init(boolean registered) {
        if (registered) {
            this.map.setFuse(2192, false);
            this.map.setFuse(2193, true);
        } else {
            this.map.setFuse(2192, true);
            this.map.setFuse(2193, false);
        }
        for (int i = 0; i < 8; ++i) {
            this.map.setFuse(2120 + i, true);
        }
    }

    @Override
    public BuilderCollector getBuilder() {
        return this.builder;
    }

    @Override
    public PinMap getPinMapping() {
        return this.pinMap;
    }

    @Override
    public void writeTo(OutputStream out) throws FuseMapFillerException, IOException, PinMapException {
        int i;
        boolean registered = !this.builder.getRegistered().isEmpty();
        this.init(registered);
        for (String in : this.builder.getInputs()) {
            i = this.pinMap.getInputFor(in) - 2;
            this.filler.addVariable(i * 2, new Variable(in));
        }
        for (String o : this.builder.getOutputs()) {
            i = 19 - this.pinMap.getOutputFor(o);
            this.filler.addVariable(i * 2 + 1, new Variable(o));
        }
        for (String o : this.builder.getOutputs()) {
            int olmc = 19 - this.pinMap.getOutputFor(o);
            int offs = olmc * 256;
            this.map.setFuse(2048 + olmc);
            if (this.builder.getCombinatorial().containsKey(o)) {
                if (registered) {
                    for (int j = 0; j < 32; ++j) {
                        this.map.setFuse(offs + j);
                    }
                    this.filler.fillExpression(offs + 32, this.builder.getCombinatorial().get(o), 7);
                    continue;
                }
                this.map.setFuse(2120 + olmc, false);
                this.filler.fillExpression(offs, this.builder.getCombinatorial().get(o), 8);
                continue;
            }
            if (this.builder.getRegistered().containsKey(o)) {
                this.map.setFuse(2120 + olmc, false);
                this.filler.fillExpression(offs, this.builder.getRegistered().get(o), 8);
                continue;
            }
            throw new FuseMapFillerException("variable " + o + " not found!");
        }
        try (JedecWriter w = new JedecWriter(out);){
            w.println("Digital GAL16v8 assembler*").write(this.map);
        }
    }
}

