/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.Gal16v8;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionVisitor;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.FormatToExpression;
import de.neemann.digital.builder.BuilderCollector;
import de.neemann.digital.builder.BuilderException;
import de.neemann.digital.builder.BuilderInterface;
import de.neemann.digital.builder.CleanNameBuilder;
import de.neemann.digital.builder.ExpressionExporter;
import de.neemann.digital.builder.Gal16v8.BuilderCollectorGAL;
import de.neemann.digital.builder.PinMap;
import de.neemann.digital.builder.PinMapException;
import de.neemann.digital.lang.Lang;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

public class CuplExporter
implements ExpressionExporter<CuplExporter> {
    private final DateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private final String username;
    private final Date date;
    private final BuilderCollector builder;
    private final CleanNameBuilder cleanNameBuilder;
    private final PinMap pinMap;
    private final String devName;
    private String projectName;
    private boolean createNodes = false;
    private int clockPin = 1;

    public CuplExporter() {
        this(System.getProperty("user.name"), new Date());
    }

    public CuplExporter(String username, Date date) {
        this(username, date, "g16v8a");
        this.getPinMapping().setAvailInputs(2, 3, 4, 5, 6, 7, 8, 9).setAvailOutputs(12, 13, 14, 15, 16, 17, 18, 19);
    }

    protected void setClockPin(int clockPin) {
        this.clockPin = clockPin;
    }

    protected CuplExporter(String username, Date date, String devName) {
        this.username = username;
        this.date = date;
        this.devName = devName;
        this.cleanNameBuilder = new CleanNameBuilder(null);
        this.pinMap = this.cleanNameBuilder.createPinMap();
        this.builder = new CuplBuilder(this.pinMap);
        this.cleanNameBuilder.setParent(this.builder);
    }

    public CuplExporter setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public void setCreateNodes(boolean createNodes) {
        this.createNodes = createNodes;
    }

    @Override
    public BuilderInterface getBuilder() {
        return this.cleanNameBuilder;
    }

    @Override
    public PinMap getPinMapping() {
        return this.pinMap;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, PinMapException {
        this.writeTo(new OutputStreamWriter(out, StandardCharsets.ISO_8859_1));
    }

    public void writeTo(Writer out) throws IOException, PinMapException {
        out.append("Name     ").append(this.projectName).append(" ;\r\n").append("PartNo   00 ;\r\n").append("Date     ").append(this.formatDate(this.date)).append(" ;\r\n").append("Revision 01 ;\r\n").append("Designer ").append(this.username).append(" ;\r\n").append("Company  unknown ;\r\n").append("Assembly None ;\r\n").append("Location unknown ;\r\n").append("Device   ").append(this.devName).append(" ;\r\n");
        this.headerWritten(out);
        out.append("\r\n/* inputs */\r\n");
        if (!this.builder.getRegistered().isEmpty()) {
            out.append("PIN ").append(String.valueOf(this.clockPin)).append(" = CLK;\r\n");
        }
        for (String string : this.builder.getInputs()) {
            out.append("PIN ").append(Integer.toString(this.pinMap.getInputFor(string))).append(" = ").append(string).append(";\r\n");
        }
        out.append("\r\n/* outputs */\r\n");
        for (String string : this.builder.getOutputs()) {
            if (this.createNodes) {
                int p = this.pinMap.isOutputAssigned(string);
                if (p >= 0) {
                    out.append("PIN ").append(Integer.toString(p)).append(" = ").append(string).append(";\r\n");
                    continue;
                }
                out.append("NODE ").append(string).append(";\r\n");
                continue;
            }
            out.append("PIN ").append(Integer.toString(this.pinMap.getOutputFor(string))).append(" = ").append(string).append(";\r\n");
        }
        if (!this.builder.getRegistered().isEmpty()) {
            out.append("\r\n/* sequential logic */\r\n");
            for (Map.Entry entry : this.builder.getRegistered().entrySet()) {
                out.append((CharSequence)entry.getKey()).append(".D = ");
                this.breakLines(out, FormatToExpression.CUPL.format((Expression)entry.getValue()));
                out.append(";\r\n");
                this.sequentialWritten(out, (String)entry.getKey());
            }
        }
        if (!this.builder.getCombinatorial().isEmpty()) {
            out.append("\r\n/* combinatorial logic */\r\n");
            for (Map.Entry entry : this.builder.getCombinatorial().entrySet()) {
                out.append((CharSequence)entry.getKey()).append(" = ");
                this.breakLines(out, FormatToExpression.CUPL.format((Expression)entry.getValue()));
                out.append(";\r\n");
            }
        }
        out.flush();
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "unknownDate";
        }
        return this.dateFormat.format(date);
    }

    private void breakLines(Writer out, String expression) throws IOException {
        int pos = 0;
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (pos > 80 && c == '#') {
                out.append("\r\n     ");
                pos = 0;
            }
            out.append(c);
            ++pos;
        }
    }

    protected void headerWritten(Writer out) throws IOException {
    }

    protected void sequentialWritten(Writer out, String name) throws IOException {
    }

    private static final class NotAllowedVariablesVisitor
    implements ExpressionVisitor {
        private static final String NOT_ALLOWED_CHARS = " &#()-+[]/:.*;,!'=@$^\"";
        private final HashSet<String> notAllowed = new HashSet();

        NotAllowedVariablesVisitor() {
            this.add("APPEND", "FUNCTION", "PARTNO", "ASSEMBLY", "FUSE", "PIN", "ASSY", "GROUP", "PINNNODE", "COMPANY", "IF", "PRESENT", "CONDITION", "JUMP", "REV", "DATE", "LOC", "REVISION", "DEFAULT", "LOCATION", "SEQUENCE", "DESIGNER", "MACRO", "SEQUENCED", "DEVICE", "MIN", "SEQUENCEJK", "ELSE", "NAME", "SEQUENCERS", "FIELD", "NODE", "SEQUENCET", "FLD", "OUT", "TABLE", "FORMAT");
            this.add("D");
        }

        private void add(String ... names) {
            Collections.addAll(this.notAllowed, names);
        }

        @Override
        public boolean visit(Expression expression) {
            if (expression instanceof Variable) {
                Variable v = (Variable)expression;
                this.check(v.getIdentifier());
            }
            return true;
        }

        private void check(String v) {
            for (int i = 0; i < NOT_ALLOWED_CHARS.length(); ++i) {
                if (v.indexOf(NOT_ALLOWED_CHARS.charAt(i)) < 0) continue;
                throw new RuntimeException(Lang.get("err_varNotAllowedInCUPL_N", v));
            }
            if (this.notAllowed.contains(v)) {
                throw new RuntimeException(Lang.get("err_varNotAllowedInCUPL_N", v));
            }
        }
    }

    private static final class CuplBuilder
    extends BuilderCollectorGAL {
        private final NotAllowedVariablesVisitor notAllowedVariablesVisitor = new NotAllowedVariablesVisitor();

        private CuplBuilder(PinMap pinMap) {
            super(pinMap);
        }

        @Override
        public BuilderCollector addCombinatorial(String name, Expression expression) throws BuilderException {
            expression.traverse(this.notAllowedVariablesVisitor);
            this.notAllowedVariablesVisitor.check(name);
            return super.addCombinatorial(name, expression);
        }

        @Override
        public BuilderCollector addSequential(String name, Expression expression) throws BuilderException {
            expression.traverse(this.notAllowedVariablesVisitor);
            this.notAllowedVariablesVisitor.check(name);
            return super.addSequential(name, expression);
        }
    }
}

