/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.Gal16v8;

import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.builder.BuilderCollector;
import de.neemann.digital.builder.BuilderException;
import de.neemann.digital.builder.PinMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class BuilderCollectorGAL
extends BuilderCollector {
    private final PinMap pinMap;
    private HashSet<String> sequentialVars;
    private boolean doubleCellUsageFixed = false;

    public BuilderCollectorGAL(PinMap pinMap) {
        this.pinMap = pinMap;
        this.sequentialVars = new HashSet();
    }

    @Override
    public BuilderCollector addCombinatorial(String name, Expression expression) throws BuilderException {
        this.checkOpen();
        return super.addCombinatorial(name, expression);
    }

    @Override
    public BuilderCollector addSequential(String name, Expression expression) throws BuilderException {
        this.checkOpen();
        this.sequentialVars.add(name);
        return super.addSequential(name, expression);
    }

    private void checkOpen() {
        if (this.doubleCellUsageFixed) {
            throw new RuntimeException("wrong BuilderCollectorGAL usage!");
        }
    }

    private void fixDoubleCellUsage() {
        if (!this.doubleCellUsageFixed) {
            super.getCombinatorial().entrySet().removeIf(c -> {
                if (this.pinMap.isSimpleAlias((String)c.getKey(), (Expression)c.getValue(), this.sequentialVars)) {
                    this.removeOutput((String)c.getKey());
                    return true;
                }
                return false;
            });
            this.doubleCellUsageFixed = true;
        }
    }

    @Override
    public ArrayList<String> getOutputs() {
        this.fixDoubleCellUsage();
        return super.getOutputs();
    }

    @Override
    public ArrayList<String> getInputs() {
        this.fixDoubleCellUsage();
        return super.getInputs();
    }

    @Override
    public Map<String, Expression> getCombinatorial() {
        this.fixDoubleCellUsage();
        return super.getCombinatorial();
    }

    @Override
    public Map<String, Expression> getRegistered() {
        this.fixDoubleCellUsage();
        return super.getRegistered();
    }
}

