/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder;

import de.neemann.digital.builder.BuilderInterface;
import de.neemann.digital.builder.ExpressionExporter;
import de.neemann.digital.builder.PinMap;
import de.neemann.digital.builder.PinMapException;
import de.neemann.digital.builder.jedec.FuseMapFillerException;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class ExpressionToFileExporter {
    private final ExpressionExporter exporter;
    private final ArrayList<PostProcess> postProcesses;

    public ExpressionToFileExporter(ExpressionExporter exporter) {
        this.exporter = exporter;
        this.postProcesses = new ArrayList();
    }

    public ExpressionExporter getExporter() {
        return this.exporter;
    }

    public PinMap getPinMapping() {
        return this.exporter.getPinMapping();
    }

    public BuilderInterface getBuilder() {
        return this.exporter.getBuilder();
    }

    public ExpressionToFileExporter addProcessingStep(PostProcess postProcess) {
        this.postProcesses.add(postProcess);
        return this;
    }

    public void export(File file) throws IOException, PinMapException, FuseMapFillerException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.exporter.writeTo(out);
        }
        for (PostProcess p : this.postProcesses) {
            try {
                file = p.execute(file);
            }
            catch (IOException e) {
                throw new IOException(Lang.get("err_postProcessErrorIn_N0", p.getName()), e);
            }
        }
    }

    public static interface PostProcess {
        public File execute(File var1) throws IOException;

        public String getName();
    }
}

