/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.ATF150x;

import de.neemann.digital.builder.ATF150x.ATFDialog;
import de.neemann.digital.builder.ExpressionToFileExporter;
import de.neemann.digital.gui.SaveAsHelper;
import de.neemann.digital.lang.Lang;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.SwingUtilities;

public class CreateCHN
implements ExpressionToFileExporter.PostProcess {
    private final String device;
    private final ATFDialog atfDialog;

    public CreateCHN(String device, ATFDialog atfDialog) {
        this.device = device;
        this.atfDialog = atfDialog;
    }

    @Override
    public File execute(File file) throws IOException {
        File chnFile = SaveAsHelper.checkSuffix(file, "chn");
        try (OutputStreamWriter chn = new OutputStreamWriter((OutputStream)new FileOutputStream(chnFile), "ISO-8859-1");){
            chn.write("1 4 1 0 \r\n\r\n" + this.device + "\r\n10\r\n1\r\n");
            chn.write(file.getPath());
            chn.write("\r\n");
        }
        SwingUtilities.invokeLater(() -> this.atfDialog.setChnFile(chnFile));
        return chnFile;
    }

    @Override
    public String getName() {
        return Lang.get("msg_create CHNFile", new Object[0]);
    }
}

