/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.builder.ATF150x;

import de.neemann.digital.builder.ATF150x.ATF150xCuplExporter;
import de.neemann.digital.builder.ATF150x.ATFDialog;
import de.neemann.digital.builder.ATF150x.CreateCHN;
import de.neemann.digital.builder.ATF150x.PL;
import de.neemann.digital.builder.ExpressionToFileExporter;
import de.neemann.digital.builder.tt2.StartATF150xFitter;
import de.neemann.digital.builder.tt2.TT2Exporter;
import java.util.Date;
import javax.swing.JDialog;

public enum ATFDevice {
    ATF1502PLCC44(1502, 43, "plcc44", 1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 16, 17, 18, 19, 20, 21, 24, 25, 26, 27, 28, 29, 31, 33, 34, 36, 37, 38, 39, 40, 41, 43, 44),
    ATF1502TQFP44(1502, 37, "t44", "tqfp44", 2, 3, 5, 6, 8, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 33, 34, 35, 37, 38, 39, 40, 42, 43, 44),
    ATF1504PLCC44(1504, 43, "plcc44", 1, 2, 4, 5, 6, 8, 9, 11, 12, 14, 16, 17, 18, 19, 20, 21, 24, 25, 26, 27, 28, 29, 31, 33, 34, 36, 37, 38, 39, 40, 41, 43, 44),
    ATF1504TQFP44(1504, 37, "t44", "tqfp44", 2, 3, 5, 6, 8, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 25, 27, 28, 30, 31, 33, 34, 35, 37, 38, 39, 40, 42, 43, 44),
    ATF1504PLCC84(1504, 83, "plcc84", new PL().pi(1, 84).e(14, 23, 62, 71).e(7, 19, 32, 42, 47, 59, 72, 82).e(3, 43).e(13, 26, 38, 53, 66, 78).pins()),
    ATF1504TQFP100(1504, 87, "t100", "tqfp100", new PL().pi(1, 100).e(4, 15, 62, 73).e(11, 26, 38, 43, 59, 74, 86, 95).e(39, 91).e(3, 18, 34, 51, 66, 82).e(1, 2, 5, 7, 22, 24, 27, 28, 49, 50, 53, 55, 70, 72, 77, 78).pins()),
    ATF1508PLCC84(1508, 81, "plcc84", 4, 5, 6, 8, 9, 10, 11, 12, 15, 16, 17, 18, 20, 21, 22, 24, 25, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 39, 40, 41, 44, 45, 46, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 60, 61, 63, 64, 65, 67, 68, 69, 70, 73, 74, 75, 76, 77, 79, 80),
    ATF1508PQFP100(1508, 89, "q100", "pqfp100", new PL().pi(1, 100).e(6, 17, 64, 75).e(13, 28, 40, 45, 61, 76, 88, 97).e(41, 93).e(5, 20, 36, 53, 68, 84).pins()),
    ATF1508TQFP100(1508, 87, "t100", "tqfp100", new PL().pi(1, 100).e(4, 15, 62, 73).e(11, 26, 38, 43, 59, 74, 86, 95).e(39, 91).e(3, 18, 34, 51, 66, 82).pins()),
    ATF1508PQFP160(1508, 139, "q160", "pqfp160", new PL().pi(1, 160).e(9, 22, 99, 112).e(17, 42, 60, 66, 95, 113, 138, 148).e(61, 143).e(8, 26, 55, 79, 104, 133).e(1, 2, 3, 4, 5, 6, 7, 34, 35, 36, 37, 38, 39, 40, 44, 45, 46, 47, 74, 75, 76, 77, 81, 82, 83, 84, 85, 86, 87, 114, 115, 116, 117, 118, 119, 120, 124, 125, 126, 127, 154, 155, 156, 157).pins());

    private final int deviceNumber;
    private final String icPackage;
    private final String packageName;
    private final int clockPin;
    private final int[] pins;

    private ATFDevice(int deviceNumber, int clockPin, String icPackage, int ... ioPins) {
        this(deviceNumber, clockPin, icPackage, icPackage, ioPins);
    }

    private ATFDevice(int deviceNumber, int clockPin, String icPackage, String packageName, int ... ioPins) {
        this.deviceNumber = deviceNumber;
        this.icPackage = icPackage;
        this.packageName = packageName;
        this.clockPin = clockPin;
        this.pins = ioPins;
    }

    private String getTT2DevName() {
        return "f" + this.deviceNumber + "isp" + this.icPackage;
    }

    public String getMenuName() {
        return "ATF" + this.deviceNumber + "/" + this.packageName.toUpperCase();
    }

    private TT2Exporter getTT2Exporter(String projectName) {
        TT2Exporter tt2 = new TT2Exporter(projectName);
        tt2.getPinMapping().setClockPin(this.clockPin).setAvailBidirectional(this.pins);
        tt2.setDevice(this.getTT2DevName());
        return tt2;
    }

    private StartATF150xFitter getStartFitter(ATFDialog dialog) {
        return new StartATF150xFitter(dialog, this.deviceNumber);
    }

    public ATF150xCuplExporter getCuplExporter() {
        return new ATF150xCuplExporter(this.getTT2DevName(), this.clockPin, this.pins);
    }

    public ATF150xCuplExporter getCuplExporter(String username, Date date) {
        return new ATF150xCuplExporter(username, date, this.getTT2DevName(), this.clockPin, this.pins);
    }

    public ExpressionToFileExporter createExpressionToFileExporter(JDialog dialog, String projectName) {
        ATFDialog d = new ATFDialog(dialog);
        return new ExpressionToFileExporter(this.getTT2Exporter(projectName)).addProcessingStep(this.getStartFitter(d)).addProcessingStep(new CreateCHN("ATF" + this.deviceNumber + "AS", d));
    }
}

