/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;

public final class TableRow
implements Comparable<TableRow> {
    private final TreeSet<Integer> source;
    private boolean used = false;
    private long optimizedFlags;
    private long state;
    private int cols;

    public TableRow(TableRow tr) {
        this(tr.size());
        this.state = tr.state;
        this.optimizedFlags = tr.optimizedFlags;
    }

    public TableRow(int cols) {
        this.cols = cols;
        this.source = new TreeSet();
    }

    public TableRow(int cols, int bitValue, int index, boolean dontCare) {
        this(cols, bitValue);
        if (!dontCare) {
            this.source.add(index);
        }
    }

    public TableRow(int cols, int bitValue) {
        this(cols);
        this.state = Integer.reverse(bitValue) >>> 32 - cols;
    }

    public void setToOptimized(int index) {
        this.state &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
        this.optimizedFlags |= 1L << index;
    }

    public long getOptimizedFlags() {
        return this.optimizedFlags;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < this.cols; ++c) {
            long mask = 1L << c;
            if ((this.optimizedFlags & mask) != 0L) {
                sb.append('-');
                continue;
            }
            if ((this.state & mask) != 0L) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        for (Integer i : this.source) {
            sb.append(",").append(i);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRow tableRow = (TableRow)o;
        return this.optimizedFlags == tableRow.optimizedFlags && this.state == tableRow.state;
    }

    public int hashCode() {
        int result = (int)(this.optimizedFlags ^ this.optimizedFlags >>> 32);
        result = 31 * result + (int)(this.state ^ this.state >>> 32);
        result = 31 * result + this.cols;
        return result;
    }

    public void setUsed() {
        this.used = true;
    }

    public boolean isUsed() {
        return this.used;
    }

    @Override
    public int compareTo(TableRow tableRow) {
        int e = Long.compare(this.optimizedFlags, tableRow.optimizedFlags);
        if (e == 0) {
            return Long.compare(this.state, tableRow.state);
        }
        return e;
    }

    public int size() {
        return this.cols;
    }

    public Collection<Integer> getSource() {
        return this.source;
    }

    public void addSource(Collection<Integer> s) {
        this.source.addAll(s);
    }

    public TableRow addSource(Integer ... s) {
        this.addSource(Arrays.asList(s));
        return this;
    }

    public Expression getExpression(List<Variable> vars) {
        Expression e = null;
        for (int i = 0; i < this.size(); ++i) {
            long mask = 1L << i;
            if ((this.optimizedFlags & mask) != 0L) continue;
            Expression term = (this.state & mask) == 0L ? Not.not(vars.get(i)) : (Expression)vars.get(i);
            e = e == null ? term : Operation.and(e, term);
        }
        if (e == null) {
            return Constant.ONE;
        }
        return e;
    }

    public int checkCompatible(TableRow r2) {
        if (this.optimizedFlags != r2.optimizedFlags) {
            return -1;
        }
        long v = this.state ^ r2.state;
        if (Long.bitCount(v) != 1) {
            return -1;
        }
        return Long.numberOfTrailingZeros(v);
    }
}

