/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.BoolTableExpanded;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.IndependentChecker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableReducer {
    private List<Variable> vars;
    private BoolTable table;

    public TableReducer(List<Variable> vars, BoolTable table) {
        this.vars = new ArrayList<Variable>(vars);
        this.table = table;
    }

    public boolean canReduce() {
        if (this.table instanceof BoolTableExpanded) {
            BoolTableExpanded t = (BoolTableExpanded)this.table;
            this.vars = new ArrayList<Variable>(t.getVars());
            this.table = t.getBoolTable();
            this.canReduceOnlyCheckTable();
            return true;
        }
        return this.canReduceOnlyCheckTable();
    }

    public boolean canReduceOnlyCheckTable() {
        boolean isReduced = false;
        Iterator<Variable> it = this.vars.iterator();
        int var = 0;
        while (it.hasNext()) {
            it.next();
            IndependentChecker ic = new IndependentChecker(this.table);
            if (ic.isIndependentFrom(var)) {
                it.remove();
                this.table = ic.removeVar(var);
                isReduced = true;
                continue;
            }
            ++var;
        }
        return isReduced;
    }

    public List<Variable> getVars() {
        return this.vars;
    }

    public BoolTable getTable() {
        return this.table;
    }
}

