/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.expression.ComplexityInclNotVisitor;
import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.BoolTableExpression;
import de.neemann.digital.analyse.quinemc.TableRow;
import de.neemann.digital.analyse.quinemc.TableRows;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import de.neemann.digital.analyse.quinemc.primeselector.PrimeSelector;
import de.neemann.digital.analyse.quinemc.primeselector.PrimeSelectorDefault;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuineMcCluskey {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuineMcCluskey.class);
    private final List<Variable> variables;
    private final ArrayList<TableRow> primes;
    private TableRows rows;

    public QuineMcCluskey(List<Variable> variables) {
        this.variables = variables;
        this.rows = new TableRows();
        this.primes = new ArrayList();
    }

    QuineMcCluskey(List<Variable> variables, TableRows rows, ArrayList<TableRow> primes) {
        this.variables = variables;
        this.rows = rows;
        this.primes = primes;
    }

    public QuineMcCluskey(Expression expression) throws ExpressionException {
        ContextFiller context = new ContextFiller(expression);
        this.variables = context.getVariables();
        this.rows = new TableRows();
        this.fillTableWith(new BoolTableExpression(expression, context));
        this.primes = new ArrayList();
    }

    public QuineMcCluskey fillTableWith(BoolTable values) throws ExpressionException {
        int n = 1 << this.variables.size();
        if (n != values.size()) {
            throw new ExpressionException(Lang.get("err_exact_N0_valuesNecessaryNot_N1", n, values.size()));
        }
        for (int i = 0; i < n; ++i) {
            ThreeStateValue value = values.get(i);
            if (value.equals((Object)ThreeStateValue.zero)) continue;
            this.add(i, value.equals((Object)ThreeStateValue.dontCare));
        }
        return this;
    }

    private void add(int i, boolean dontCare) {
        this.rows.add(new TableRow(this.variables.size(), i, this.rows.size() + 1, dontCare));
    }

    public static Expression simplify(Expression expression) throws ExpressionException {
        int initialCplx = expression.traverse(new ComplexityInclNotVisitor()).getComplexity();
        Expression newExp = new QuineMcCluskey(expression).simplify().getExpression();
        int newCplx = newExp.traverse(new ComplexityInclNotVisitor()).getComplexity();
        if (newCplx < initialCplx) {
            return newExp;
        }
        return expression;
    }

    public QuineMcCluskey simplify() {
        return this.simplify(new PrimeSelectorDefault());
    }

    public QuineMcCluskey simplify(PrimeSelector ps) {
        while (!this.isFinished()) {
            LOGGER.debug("QMC rows " + this.rows.size());
            this.simplifyStep();
        }
        this.simplifyPrimes(ps);
        return this;
    }

    public void simplifyStep() {
        TableRows newRows = new TableRows();
        for (TableRows.InnerList list : this.rows.listIterable()) {
            for (int i = 0; i < list.size() - 1; ++i) {
                for (int j = i + 1; j < list.size(); ++j) {
                    TableRow r2;
                    TableRow r1 = list.get(i);
                    int index = r1.checkCompatible(r2 = list.get(j));
                    if (index < 0) continue;
                    TableRow newRow = new TableRow(r1);
                    newRow.setToOptimized(index);
                    if (!newRows.contains(newRow)) {
                        newRow.addSource(r1.getSource());
                        newRow.addSource(r2.getSource());
                        newRows.add(newRow);
                    }
                    r1.setUsed();
                    r2.setUsed();
                }
            }
        }
        for (TableRow row : this.rows) {
            if (row.isUsed() || row.getSource().size() <= 0) continue;
            this.primes.add(row);
        }
        this.rows = newRows;
    }

    public boolean isFinished() {
        return this.rows.isEmpty();
    }

    public TableRows getRows() {
        return this.rows;
    }

    public void setRows(TableRows rows) {
        this.rows = rows;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<TableRow> newList = new ArrayList<TableRow>();
        for (TableRow r : this.rows) {
            newList.add(r);
        }
        Collections.sort(newList);
        for (TableRow r : newList) {
            sb.append(r.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public ArrayList<TableRow> getPrimes() {
        return this.primes;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Expression getExpression() {
        if (this.primes.isEmpty() && this.rows.isEmpty()) {
            return Constant.ZERO;
        }
        Expression e = QuineMcCluskey.addAnd(null, this.primes, this.variables);
        return QuineMcCluskey.addAnd(e, this.rows, this.variables);
    }

    public static Expression addAnd(Expression e, Iterable<TableRow> rows, List<Variable> variables) {
        for (TableRow r : rows) {
            Expression n = r.getExpression(variables);
            if (e == null) {
                e = n;
                continue;
            }
            e = Operation.or(e, n);
        }
        return e;
    }

    public void simplifyPrimes(PrimeSelector primeSelector) {
        TreeSet<Integer> columns = new TreeSet<Integer>();
        for (TableRow tableRow : this.primes) {
            columns.addAll(tableRow.getSource());
        }
        LOGGER.debug("initial primes " + this.primes.size());
        while (true) {
            HashSet<TableRow> rowsToDelete = new HashSet<TableRow>();
            for (TableRow r1 : this.primes) {
                for (TableRow r2 : this.primes) {
                    if (r1 == r2 || rowsToDelete.contains(r1) || !r1.getSource().containsAll(r2.getSource())) continue;
                    rowsToDelete.add(r2);
                }
            }
            this.primes.removeAll(rowsToDelete);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Iterator<Object> iterator = columns.iterator();
            while (iterator.hasNext()) {
                int c1 = (Integer)iterator.next();
                Iterator iterator2 = columns.iterator();
                while (iterator2.hasNext()) {
                    int c2 = (Integer)iterator2.next();
                    if (c1 == c2 || hashSet.contains(c1) || !this.smaller(c1, c2, this.primes)) continue;
                    hashSet.add(c2);
                }
            }
            if (hashSet.isEmpty() && rowsToDelete.isEmpty()) break;
            for (TableRow p : this.primes) {
                p.getSource().removeAll(hashSet);
            }
            columns.removeAll(hashSet);
        }
        LOGGER.debug("residual primes " + this.primes.size());
        if (primeSelector != null && !columns.isEmpty()) {
            ArrayList<TableRow> availPrimes = new ArrayList<TableRow>(this.primes.size());
            availPrimes.addAll(this.primes);
            this.primes.clear();
            primeSelector.select(this.primes, availPrimes, columns);
            LOGGER.debug("final primes " + this.primes.size());
        }
    }

    private boolean smaller(int c1, int c2, ArrayList<TableRow> primes) {
        for (TableRow r : primes) {
            Collection<Integer> s = r.getSource();
            if (!s.contains(c1) || s.contains(c2)) continue;
            return false;
        }
        return true;
    }
}

