/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;

public final class IndependentChecker {
    private final BoolTable boolTable;
    private final int vars;
    private final int checkSize;

    public IndependentChecker(BoolTable boolTable) {
        this.boolTable = boolTable;
        int v = 0;
        int s = boolTable.size();
        while (s > 1) {
            s /= 2;
            ++v;
        }
        this.vars = v;
        this.checkSize = boolTable.size() / 2;
    }

    public int getVars() {
        return this.vars;
    }

    public boolean isIndependentFrom(int varNum) {
        int bitMask = 1 << this.vars - varNum - 1;
        int lowMask = bitMask - 1;
        int highMask = ~lowMask;
        for (int n = 0; n < this.checkSize; ++n) {
            ThreeStateValue v2;
            int i1 = n & lowMask | (n & highMask) << 1;
            int i2 = i1 | bitMask;
            ThreeStateValue v1 = this.boolTable.get(i1);
            if (v1.equals((Object)(v2 = this.boolTable.get(i2))) || v1.equals((Object)ThreeStateValue.dontCare) || v2.equals((Object)ThreeStateValue.dontCare)) continue;
            return false;
        }
        return true;
    }

    public BoolTable removeVar(int varNum) {
        if (varNum >= this.vars || varNum < 0) {
            throw new RuntimeException("variable does not exist");
        }
        return new BoolTableRemoveVar(this.boolTable, this.vars, varNum);
    }

    private static final class BoolTableRemoveVar
    implements BoolTable {
        private final BoolTable boolTable;
        private final int bitMask;
        private final int lowMask;
        private final int highMask;
        private final int size;

        private BoolTableRemoveVar(BoolTable boolTable, int vars, int varNum) {
            this.boolTable = boolTable;
            this.bitMask = 1 << vars - varNum - 1;
            this.lowMask = this.bitMask - 1;
            this.highMask = ~this.lowMask;
            this.size = 1 << vars - 1;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ThreeStateValue get(int n) {
            int i = n & this.lowMask | (n & this.highMask) << 1;
            ThreeStateValue v = this.boolTable.get(i);
            if (v.equals((Object)ThreeStateValue.dontCare)) {
                return this.boolTable.get(i | this.bitMask);
            }
            return v;
        }
    }
}

