/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.quinemc;

import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;

public class BoolTableByteArray
implements BoolTable {
    private final byte[] table;

    public BoolTableByteArray(int rows) {
        this(new byte[rows]);
    }

    public BoolTableByteArray(byte[] table) {
        this.table = table;
    }

    public BoolTableByteArray(String values) {
        this(BoolTableByteArray.parseString(values));
    }

    private static byte[] parseString(String values) {
        byte[] table = new byte[values.length()];
        block4: for (int i = 0; i < values.length(); ++i) {
            switch (values.charAt(i)) {
                case '0': {
                    table[i] = 0;
                    continue block4;
                }
                case '1': {
                    table[i] = 1;
                    continue block4;
                }
                default: {
                    table[i] = 2;
                }
            }
        }
        return table;
    }

    public BoolTableByteArray(BoolTable values) {
        this.table = new byte[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            this.table[i] = (byte)values.get(i).asInt();
        }
    }

    @Override
    public int size() {
        return this.table.length;
    }

    @Override
    public ThreeStateValue get(int i) {
        return ThreeStateValue.value(this.table[i]);
    }

    public void set(int row, boolean bool) {
        this.set(row, bool ? 1 : 0);
    }

    public void set(int row, int value) {
        this.table[row] = (byte)value;
    }

    public static BoolTableByteArray createDoubledValues(BoolTable values) {
        BoolTableByteArray t = new BoolTableByteArray(values.size() * 2);
        for (int i = 0; i < values.size(); ++i) {
            int v = values.get(i).asInt();
            t.set(i * 2, v);
            t.set(i * 2 + 1, v);
        }
        return t;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.table.length);
        block4: for (byte b : this.table) {
            switch (b) {
                case 0: {
                    sb.append('0');
                    continue block4;
                }
                case 1: {
                    sb.append('1');
                    continue block4;
                }
                default: {
                    sb.append('X');
                }
            }
        }
        return sb.toString();
    }

    public void modify(TableModifier m) {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = m.modify(this.table[i]);
        }
    }

    public static interface TableModifier {
        public byte modify(byte var1);
    }
}

