/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.format;

import de.neemann.digital.analyse.ModelAnalyserInfo;
import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.format.TruthTableFormatter;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import java.util.ArrayList;
import java.util.HashMap;

public class TruthTableFormatterTestCase
implements TruthTableFormatter {
    private final ArrayList<ModelAnalyserInfo.Bus> inputBusList;
    private final ArrayList<ModelAnalyserInfo.Bus> outputBusList;

    public TruthTableFormatterTestCase(ModelAnalyserInfo modelAnalyzerInfo) {
        if (modelAnalyzerInfo == null) {
            this.inputBusList = new ArrayList();
            this.outputBusList = new ArrayList();
        } else {
            this.inputBusList = modelAnalyzerInfo.getInputBusList();
            this.outputBusList = modelAnalyzerInfo.getOutputBusList();
        }
    }

    @Override
    public String format(TruthTable truthTable) throws ExpressionException {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> inputs = new ArrayList<String>();
        for (Variable v : truthTable.getVars()) {
            inputs.add(v.getIdentifier());
        }
        ArrayList<Type> inputOutType = this.outVars(sb, inputs, this.inputBusList);
        ArrayList<String> outputs = new ArrayList<String>();
        for (int i = 0; i < truthTable.getResultCount(); ++i) {
            outputs.add(truthTable.getResultName(i));
        }
        ArrayList<Type> outputOutType = this.outVars(sb, outputs, this.outputBusList);
        sb.append("\n\n");
        ContextFiller cf = new ContextFiller(truthTable.getVars());
        for (int i = 0; i < cf.getRowCount(); ++i) {
            cf.setContextTo(i);
            int ind = 0;
            for (Variable v : cf) {
                this.outValue(sb, inputOutType.get(ind++), ThreeStateValue.value(cf.get(v)));
            }
            ind = 0;
            for (int j = 0; j < truthTable.getResultCount(); ++j) {
                this.outValue(sb, outputOutType.get(ind++), truthTable.getResult(j).get(i));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void outValue(StringBuilder sb, Type type, ThreeStateValue b) {
        switch (type) {
            case NORMAL: {
                sb.append(" ").append(this.formatValue(b));
                break;
            }
            case FIRSTBIN: {
                sb.append(" 0b").append(this.formatValue(b));
                break;
            }
            case BIN: {
                sb.append(this.formatValue(b));
            }
        }
    }

    private ArrayList<Type> outVars(StringBuilder sb, ArrayList<String> vars, ArrayList<ModelAnalyserInfo.Bus> busList) {
        ArrayList<Type> types = new ArrayList<Type>(vars.size());
        HashMap<String, String> map = new HashMap<String, String>();
        for (ModelAnalyserInfo.Bus b : busList) {
            String last = null;
            for (String s : b.getSignalNames()) {
                map.put(s, "");
                last = s;
            }
            map.put(last, b.getBusName());
        }
        for (String n : vars) {
            String r = (String)map.get(n);
            if (r == null) {
                sb.append(n).append(" ");
                types.add(Type.NORMAL);
                continue;
            }
            if (!r.isEmpty()) {
                sb.append(r).append(" ");
                types.add(Type.FIRSTBIN);
                continue;
            }
            types.add(Type.BIN);
        }
        return types;
    }

    private String formatValue(ThreeStateValue r) {
        switch (r) {
            case one: {
                return "1";
            }
            case zero: {
                return "0";
            }
            case dontCare: {
                return "x";
            }
        }
        return null;
    }

    private static enum Type {
        NORMAL,
        FIRSTBIN,
        BIN;

    }
}

