/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.format;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.format.TruthTableFormatter;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import de.neemann.digital.core.Bits;

public class TruthTableFormatterCSV
implements TruthTableFormatter {
    @Override
    public String format(TruthTable truthTable) throws ExpressionException {
        StringBuilder sb = new StringBuilder();
        for (String n : truthTable.getVarNames()) {
            sb.append(n).append(",");
        }
        for (String n : truthTable.getResultNames()) {
            sb.append(',').append(n);
        }
        sb.append('\n');
        this.export(sb, truthTable);
        return sb.toString();
    }

    private void export(StringBuilder sb, TruthTable truthTable) {
        int vars = truthTable.getVars().size();
        for (int r = 0; r < truthTable.getRows(); ++r) {
            int c;
            long m = Bits.up(1L, vars - 1);
            for (c = 0; c < vars; ++c) {
                if (((long)r & m) == 0L) {
                    sb.append('0');
                } else {
                    sb.append('1');
                }
                sb.append(',');
                m >>= 1;
            }
            for (c = 0; c < truthTable.getResultCount(); ++c) {
                ThreeStateValue v = truthTable.getResult(c).get(r);
                sb.append(',').append(v.toString());
            }
            sb.append('\n');
        }
    }
}

