/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression.format;

import de.neemann.digital.analyse.expression.ContextFiller;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.Formatter;

public class FormatToTable
implements Formatter {
    @Override
    public String format(Expression expression) throws ExpressionException {
        StringBuilder sb = new StringBuilder();
        ContextFiller cf = new ContextFiller(expression);
        this.formatHead(sb, cf.getVarCount());
        for (Variable v : cf) {
            sb.append(this.formatVariable(v));
        }
        sb.append(this.formatResultVariable());
        sb.append("\n");
        this.formatTableStart(sb);
        for (int i = 0; i < cf.getRowCount(); ++i) {
            cf.setContextTo(i);
            for (Variable v : cf) {
                sb.append(this.formatValue(cf.get(v)));
            }
            sb.append(this.formatResult(expression.calculate(cf)));
            sb.append("\n");
        }
        this.formatEnd(sb);
        return sb.toString();
    }

    protected void formatHead(StringBuilder sb, int varCount) {
    }

    protected void formatTableStart(StringBuilder sb) {
    }

    protected void formatEnd(StringBuilder sb) {
    }

    protected String formatVariable(Variable v) {
        return v.getIdentifier();
    }

    protected String formatResultVariable() {
        return "|Y";
    }

    protected String formatResult(boolean value) {
        return "|" + this.formatValue(value);
    }

    protected String formatValue(boolean val) {
        if (val) {
            return "1";
        }
        return "0";
    }
}

