/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression.format;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.Operation;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.expression.format.Formatter;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.draw.graphics.text.formatter.PlainTextFormatter;
import de.neemann.digital.draw.graphics.text.text.ExpressionToText;
import de.neemann.digital.gui.Settings;

public enum FormatToExpression implements Formatter
{
    JAVA("||", "&&", "^", "!", "false", "true", "="),
    DERIVE("OR", "AND", "XOR", "NOT ", "false", "true", "="),
    CUPL("#", "&", "$", "!", "'b'0", "'b'1", "=", true),
    LOGISIM("+", "", "^", "~", "false", "true", "="),
    UNICODE("\u2228", "\u2227", "\u22bb", "\u00ac", "0", "1", "="),
    UNICODE_NOAND("\u2228", "", "\u22bb", "\u00ac", "0", "1", "="),
    SHORT("+", "*", "^", "!", "0", "1", "="),
    SHORTER("+", "", "^", "!", "0", "1", "="),
    LATEX("\\oder", "\\und", "\\xoder", "", "0", "1", "&=&");

    private static final Expression TOSTRING_EXPR;
    private final String orString;
    private final String andString;
    private final String falseString;
    private final String trueString;
    private final String equal;
    private final String xorString;
    private final String notString;
    private final boolean keepVars;
    private String name;

    public static FormatToExpression getDefaultFormat() {
        return Settings.getInstance().get(Keys.SETTINGS_EXPRESSION_FORMAT);
    }

    public static String defaultFormat(Expression exp) {
        return FormatToExpression.getDefaultFormat().format(exp);
    }

    private FormatToExpression(String orString, String andString, String xorString, String notString, String falseString, String trueString, String equal) {
        this(orString, andString, xorString, notString, falseString, trueString, equal, false);
    }

    private FormatToExpression(String orString, String andString, String xorString, String notString, String falseString, String trueString, String equal, boolean keepVars) {
        this.orString = orString;
        this.andString = andString;
        this.xorString = xorString;
        this.notString = notString;
        this.falseString = falseString;
        this.trueString = trueString;
        this.equal = equal;
        this.keepVars = keepVars;
    }

    public String getOrString() {
        return this.orString;
    }

    public String getAndString() {
        return this.andString;
    }

    public String getXorString() {
        return this.xorString;
    }

    public String getNot() {
        return this.notString;
    }

    public String getEqual() {
        return this.equal;
    }

    public String constant(boolean value) {
        if (value) {
            return this.trueString;
        }
        return this.falseString;
    }

    @Override
    public String format(Expression expression) {
        return PlainTextFormatter.format(new ExpressionToText().setFormatIdentifiers(!this.keepVars).createText(expression, this), this);
    }

    public String toString() {
        if (this.name == null) {
            this.name = this.format(TOSTRING_EXPR);
        }
        return this.name;
    }

    static {
        Variable a = Variable.v("A");
        Variable b = Variable.v("B");
        TOSTRING_EXPR = Operation.or(Operation.and(a, Not.not(b)), Operation.and(Not.not(a), b), Constant.ZERO);
    }
}

