/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression;

import de.neemann.digital.analyse.expression.Context;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.ExpressionVisitor;
import de.neemann.digital.analyse.expression.Not;
import java.util.ArrayList;

public class Variable
implements Comparable<Variable>,
Expression {
    private String identifier;

    public static Variable v(String name) {
        return new Variable(name);
    }

    public static ArrayList<Variable> vars(int n) {
        ArrayList<Variable> v = new ArrayList<Variable>();
        for (int i = 0; i < n; ++i) {
            v.add(new Variable("" + (char)(65 + i)));
        }
        return v;
    }

    public static ArrayList<Variable> vars(String ... names) {
        ArrayList<Variable> v = new ArrayList<Variable>();
        for (String n : names) {
            v.add(new Variable(n));
        }
        return v;
    }

    public static boolean isVar(Expression e) {
        return e instanceof Variable;
    }

    public static boolean isVarOrNotVar(Expression e) {
        return Variable.isVar(e) || e instanceof Not && Variable.isVar(((Not)e).getExpression());
    }

    public Variable(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public boolean calculate(Context context) throws ExpressionException {
        return context.get(this);
    }

    @Override
    public <V extends ExpressionVisitor> V traverse(V v) {
        v.visit(this);
        return v;
    }

    @Override
    public String getOrderString() {
        return this.identifier;
    }

    @Override
    public Expression copy() {
        return new Variable(this.identifier);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable that = (Variable)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public int compareTo(Variable o) {
        return this.identifier.compareTo(o.identifier);
    }
}

