/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Context;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.ExpressionVisitor;
import de.neemann.digital.analyse.expression.Not;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public abstract class Operation
implements Expression {
    private static final Comparator<Expression> EXPRESSION_COMPARATOR = Comparator.comparing(Expression::getOrderString);
    private final ArrayList<Expression> expr = new ArrayList();

    public static Expression or(Iterable<Expression> exp) {
        return Operation.simplify(new Or(exp, true));
    }

    public static Expression or(Expression ... exp) {
        return Operation.simplify(new Or(Arrays.asList(exp), true));
    }

    public static Expression xor(Expression a, Expression b) {
        if (b == Constant.ONE) {
            return Not.not(a);
        }
        if (b == Constant.ZERO) {
            return a;
        }
        if (a == Constant.ONE) {
            return Not.not(b);
        }
        if (a == Constant.ZERO) {
            return b;
        }
        return Operation.simplify(new XOr(a, b));
    }

    public static Expression orNoMerge(Expression ... exp) {
        return Operation.simplify(new Or(Arrays.asList(exp), false));
    }

    public static Expression and(Iterable<Expression> exp) {
        return Operation.simplify(new And(exp, true));
    }

    public static Expression and(Expression ... exp) {
        return Operation.simplify(new And(Arrays.asList(exp), true));
    }

    public static Expression andNoMerge(Expression ... exp) {
        return Operation.simplify(new And(Arrays.asList(exp), false));
    }

    private static Expression simplify(Operation operation) {
        int size = operation.getExpressions().size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return operation.getExpressions().get(0);
            }
        }
        operation.getExpressions().sort(EXPRESSION_COMPARATOR);
        return operation;
    }

    private Operation(Iterable<Expression> exp, boolean merge) {
        for (Expression e : exp) {
            if (e == null) continue;
            if (merge) {
                this.merge(e);
                continue;
            }
            this.expr.add(e);
        }
    }

    private Operation(Iterable<Expression> expToCopy) {
        for (Expression e : expToCopy) {
            if (e == null) continue;
            this.expr.add(e.copy());
        }
    }

    private void merge(Expression e) {
        if (e.getClass() == this.getClass()) {
            this.expr.addAll(((Operation)e).getExpressions());
        } else {
            this.expr.add(e);
        }
    }

    @Override
    public boolean calculate(Context context) throws ExpressionException {
        boolean result = this.getNeutral();
        for (Expression e : this.expr) {
            result = this.calc(result, e.calculate(context));
        }
        return result;
    }

    @Override
    public <V extends ExpressionVisitor> V traverse(V v) {
        if (v.visit(this)) {
            for (Expression e : this.expr) {
                e.traverse(v);
            }
        }
        return v;
    }

    @Override
    public void modify(ExpressionModifier modifier) {
        for (int i = 0; i < this.expr.size(); ++i) {
            Expression e = this.expr.get(i);
            e.modify(modifier);
            this.expr.set(i, modifier.modify(e));
        }
    }

    public ArrayList<Expression> getExpressions() {
        return this.expr;
    }

    @Override
    public String getOrderString() {
        return this.expr.get(0).getOrderString();
    }

    protected abstract boolean getNeutral();

    protected abstract boolean calc(boolean var1, boolean var2);

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        for (Expression e : this.expr) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(e.toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static final class XOr
    extends Operation {
        private XOr(Expression a, Expression b) {
            super(Arrays.asList(a, b), false);
        }

        private XOr(Iterable<Expression> expToCopy) {
            super(expToCopy);
        }

        @Override
        protected boolean getNeutral() {
            return false;
        }

        @Override
        protected boolean calc(boolean a, boolean b) {
            return !(!a && !b || a && b);
        }

        @Override
        public String toString() {
            return "xor" + super.toString();
        }

        @Override
        public Expression copy() {
            return new XOr(this.getExpressions());
        }
    }

    public static final class Or
    extends Operation {
        private Or(Iterable<Expression> exp, boolean merge) {
            super(exp, merge);
        }

        private Or(Iterable<Expression> expToCopy) {
            super(expToCopy);
        }

        @Override
        protected boolean getNeutral() {
            return false;
        }

        @Override
        protected boolean calc(boolean a, boolean b) {
            return a || b;
        }

        @Override
        public String toString() {
            return "or" + super.toString();
        }

        @Override
        public Expression copy() {
            return new Or(this.getExpressions());
        }
    }

    public static final class And
    extends Operation {
        private And(Iterable<Expression> exp, boolean merge) {
            super(exp, merge);
        }

        private And(Iterable<Expression> expToCopy) {
            super(expToCopy);
        }

        @Override
        protected boolean getNeutral() {
            return true;
        }

        @Override
        protected boolean calc(boolean a, boolean b) {
            return a && b;
        }

        @Override
        public String toString() {
            return "and" + super.toString();
        }

        @Override
        public Expression copy() {
            return new And(this.getExpressions());
        }
    }
}

