/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse.expression;

import de.neemann.digital.analyse.expression.Constant;
import de.neemann.digital.analyse.expression.Context;
import de.neemann.digital.analyse.expression.Expression;
import de.neemann.digital.analyse.expression.ExpressionException;
import de.neemann.digital.analyse.expression.ExpressionVisitor;
import de.neemann.digital.analyse.expression.modify.ExpressionModifier;
import java.util.Objects;

public final class Not
implements Expression {
    private Expression expression;
    private boolean protect = false;

    public static Expression not(Expression a) {
        if (a == Constant.ONE) {
            return Constant.ZERO;
        }
        if (a == Constant.ZERO) {
            return Constant.ONE;
        }
        if (a instanceof Not && !((Not)a).protect) {
            return ((Not)a).expression;
        }
        return new Not(a);
    }

    public Not(Expression expression) {
        this.expression = expression;
    }

    public Not protect() {
        this.protect = true;
        return this;
    }

    public boolean isProtected() {
        return this.protect;
    }

    @Override
    public boolean calculate(Context context) throws ExpressionException {
        return !this.expression.calculate(context);
    }

    @Override
    public <V extends ExpressionVisitor> V traverse(V v) {
        if (v.visit(this)) {
            this.expression.traverse(v);
        }
        return v;
    }

    @Override
    public void modify(ExpressionModifier modifier) {
        this.expression.modify(modifier);
        this.expression = modifier.modify(this.expression);
    }

    @Override
    public String getOrderString() {
        return this.expression.getOrderString();
    }

    @Override
    public Expression copy() {
        return new Not(this.expression.copy());
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return "not(" + this.expression + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Not not = (Not)o;
        return this.expression.equals(not.expression);
    }

    public int hashCode() {
        return Objects.hash(this.expression);
    }
}

