/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.undo.ModifyException;
import de.neemann.digital.undo.UndoManager;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TruthTableTableModel
implements TableModel {
    public static final String[] STATENAMES = new String[]{"0", "1", "x"};
    private final ArrayList<TableModelListener> listeners = new ArrayList();
    private final UndoManager<TruthTable> undoManager;

    public TruthTableTableModel(UndoManager<TruthTable> undoManager) {
        this.undoManager = undoManager;
    }

    @Override
    public int getRowCount() {
        return this.undoManager.getActual().getRows();
    }

    @Override
    public int getColumnCount() {
        return this.undoManager.getActual().getCols();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.undoManager.getActual().getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Integer.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.undoManager.getActual().isEditable(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.undoManager.getActual().getValue(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Integer) {
            this.setValue(rowIndex, columnIndex, (Integer)aValue);
        }
        if (aValue instanceof String) {
            if (aValue.toString().equals("0")) {
                this.setValue(rowIndex, columnIndex, 0);
            } else if (aValue.toString().equals("1")) {
                this.setValue(rowIndex, columnIndex, 1);
            } else {
                this.setValue(rowIndex, columnIndex, 2);
            }
        }
    }

    private void setValue(int rowIndex, int columnIndex, int val) {
        int actVal = this.undoManager.getActual().getValue(rowIndex, columnIndex);
        if (actVal != val) {
            try {
                this.undoManager.apply(truthTable -> truthTable.setValue(rowIndex, columnIndex, val));
            }
            catch (ModifyException e) {
                e.printStackTrace();
            }
            this.fireModelEvent(rowIndex);
        }
    }

    private void fireModelEvent(int rowIndex) {
        TableModelEvent e = new TableModelEvent(this, rowIndex);
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    public void fireTableChanged() {
        TableModelEvent e = new TableModelEvent(this, -1);
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public void setColumnName(int columnIndex, String name) {
        try {
            this.undoManager.apply(truthTable -> truthTable.setColumnName(columnIndex, name));
        }
        catch (ModifyException e) {
            e.printStackTrace();
        }
        this.fireModelEvent(-1);
    }

    public void incValue(BoolTable boolTable, int row) {
        int col = -1;
        TruthTable tt = this.undoManager.getActual();
        for (int i = 0; i < tt.getResultCount(); ++i) {
            if (tt.getResult(i) != boolTable) continue;
            col = i;
            break;
        }
        if (col >= 0) {
            int value = tt.getValue(row, col += tt.getVars().size());
            value = value == 2 ? 0 : ++value;
            this.setValueAt(value, row, col);
        }
    }

    public TruthTable getTable() {
        return this.undoManager.getActual();
    }
}

