/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.core.Bits;
import de.neemann.digital.core.element.ElementAttributes;
import de.neemann.digital.core.element.ElementTypeDescription;
import de.neemann.digital.core.element.Key;
import de.neemann.digital.core.element.Keys;
import de.neemann.digital.core.element.Rotation;
import de.neemann.digital.core.flipflops.FlipflopJK;
import de.neemann.digital.core.flipflops.FlipflopT;
import de.neemann.digital.core.io.InValue;
import de.neemann.digital.core.memory.Counter;
import de.neemann.digital.core.memory.CounterPreset;
import de.neemann.digital.core.memory.DataField;
import de.neemann.digital.core.memory.Register;
import de.neemann.digital.draw.elements.Circuit;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.draw.elements.VisualElement;
import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.draw.library.ElementNotFoundException;
import de.neemann.digital.draw.library.LibraryInterface;
import de.neemann.digital.draw.model.InverterConfig;
import de.neemann.digital.draw.shapes.ShapeFactory;
import de.neemann.digital.hdl.hgs.Context;
import de.neemann.digital.hdl.hgs.HGSEvalException;
import de.neemann.digital.hdl.hgs.HGSMap;
import de.neemann.digital.hdl.hgs.Parser;
import de.neemann.digital.hdl.hgs.ParserException;
import de.neemann.digital.hdl.hgs.Statement;
import de.neemann.digital.lang.Lang;
import de.neemann.digital.testing.TestCaseDescription;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstituteLibrary
implements LibraryInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubstituteLibrary.class);
    private static final Map<String, SubstituteInterface> MAP = new HashMap<String, SubstituteInterface>();
    private final ElementLibrary parent;

    public SubstituteLibrary(ElementLibrary parent) {
        this.parent = parent;
    }

    @Override
    public ElementTypeDescription getElementType(String elementName, ElementAttributes attr) throws ElementNotFoundException {
        SubstituteInterface subst = MAP.get(elementName);
        if (subst != null) {
            try {
                ElementTypeDescription type = subst.getElementType(attr, this.parent);
                if (type != null) {
                    return type;
                }
            }
            catch (PinException | IOException e) {
                throw new ElementNotFoundException(Lang.get("err_substitutingError", new Object[0]), e);
            }
        }
        return this.parent.getElementType(elementName, attr);
    }

    @Override
    public ShapeFactory getShapeFactory() {
        return this.parent.getShapeFactory();
    }

    static Object doImplicitTypeCasts(Class<?> expectedClass, Object val) {
        if (expectedClass == Integer.class && val instanceof Long) {
            long l = (Long)val;
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
        } else {
            if (expectedClass == Long.class && val instanceof Number) {
                return ((Number)val).longValue();
            }
            if (expectedClass == Color.class && val instanceof Number) {
                return new Color(((Number)val).intValue());
            }
            if (expectedClass == Boolean.class && val instanceof Number) {
                long b = ((Number)val).longValue();
                return b != 0L;
            }
            if (expectedClass == InValue.class) {
                if (val instanceof Number) {
                    return new InValue(((Number)val).longValue());
                }
                try {
                    return new InValue(val.toString());
                }
                catch (Bits.NumberFormatException e) {
                    return val;
                }
            }
            if (expectedClass == InverterConfig.class && val instanceof List) {
                InverterConfig.Builder b = new InverterConfig.Builder();
                for (Object i : (List)val) {
                    b.add(i.toString());
                }
                return b.build();
            }
            if (expectedClass == DataField.class && val instanceof List) {
                List list = (List)val;
                long[] longs = new long[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof Number)) {
                        return val;
                    }
                    longs[i] = ((Number)list.get(i)).longValue();
                }
                return new DataField(longs);
            }
            if (expectedClass == Rotation.class && val instanceof Number) {
                int r = ((Number)val).intValue();
                return new Rotation(r % 4);
            }
            if (expectedClass == File.class && val instanceof String) {
                return new File(val.toString());
            }
            if (expectedClass == TestCaseDescription.class && val instanceof String) {
                try {
                    return new TestCaseDescription(val.toString());
                }
                catch (Exception e) {
                    return val;
                }
            }
            if (expectedClass.isEnum() && val instanceof Number) {
                Class<?> e = expectedClass;
                ?[] values = e.getEnumConstants();
                int index = ((Number)val).intValue();
                if (index < 0 || index >= values.length) {
                    return values[0];
                }
                return values[index];
            }
        }
        return val;
    }

    static {
        MAP.put(FlipflopJK.DESCRIPTION.getName(), new SubstituteGenericHGSParser("JK_FF.dig"));
        MAP.put(FlipflopT.DESCRIPTION.getName(), new SubstituteMatching().add(attr -> attr.get(Keys.WITH_ENABLE), new SubstituteGenericHGSParser("T_FF_EN.dig")).add(attr -> true, new SubstituteGenericHGSParser("T_FF.dig")));
        MAP.put(Counter.DESCRIPTION.getName(), new SubstituteGenericHGSParser("Counter.dig"));
        MAP.put(CounterPreset.DESCRIPTION.getName(), new SubstituteGenericHGSParser("CounterPreset.dig"));
        MAP.put(Register.DESCRIPTION.getName(), new SubstituteGenericHGSParser("Register.dig"));
    }

    public static final class AllowSetAttributes
    implements HGSMap {
        private final ElementAttributes attr;

        public AllowSetAttributes(ElementAttributes attr) {
            this.attr = attr;
        }

        @Override
        public void hgsMapPut(String key, Object val) throws HGSEvalException {
            Key k = Keys.getKeyByName(key);
            if (k == null) {
                throw new HGSEvalException("key " + key + " is invalid");
            }
            Class<?> expectedClass = k.getDefault().getClass();
            boolean isAssignable = expectedClass.isAssignableFrom((val = SubstituteLibrary.doImplicitTypeCasts(expectedClass, val)).getClass());
            if (!isAssignable) {
                throw new HGSEvalException("error writing to " + key + ": value of type " + val.getClass().getSimpleName() + " can't be assigned to " + expectedClass.getSimpleName());
            }
            this.attr.set(k, val);
        }

        @Override
        public Object hgsMapGet(String key) {
            return this.attr.hgsMapGet(key);
        }
    }

    private static final class SubstituteGenericHGSParser
    extends SubstituteGeneric {
        private final HashMap<String, Statement> map = new HashMap();

        private SubstituteGenericHGSParser(String filename) {
            super(filename);
        }

        @Override
        void generify(ElementAttributes sourceAttributes, String gen, ElementAttributes nodeAttributes) throws IOException {
            try {
                Statement s = this.map.get(gen);
                if (s == null) {
                    LOGGER.debug("generic: " + gen);
                    s = new Parser(gen).parse(false);
                    this.map.put(gen, s);
                }
                Context context = new Context((File)null).declareVar("orig", sourceAttributes).declareVar("this", new AllowSetAttributes(nodeAttributes));
                s.execute(context);
            }
            catch (HGSEvalException | ParserException e) {
                throw new IOException(e);
            }
        }
    }

    private static abstract class SubstituteGeneric
    implements SubstituteInterface {
        private final String filename;
        private Circuit circuit;

        private SubstituteGeneric(String filename) {
            this.filename = filename;
        }

        @Override
        public ElementTypeDescription getElementType(ElementAttributes attr, ElementLibrary library) throws PinException, IOException {
            if (this.circuit == null) {
                LOGGER.debug("load substitute circuit " + this.filename);
                InputStream in = this.getClass().getClassLoader().getResourceAsStream("analyser/" + this.filename);
                if (in == null) {
                    throw new IOException("substituting failed: could not find file " + this.filename);
                }
                this.circuit = Circuit.loadCircuit(in, library.getShapeFactory());
            }
            Circuit c = this.circuit.createDeepCopy();
            c.getAttributes().set(Keys.IS_GENERIC, false);
            this.generify(attr, c);
            return ElementLibrary.createCustomDescription(new File(this.filename), c, library);
        }

        private void generify(ElementAttributes attr, Circuit circuit) throws IOException {
            for (VisualElement v : circuit.getElements()) {
                String gen = v.getElementAttributes().get(Keys.GENERIC).trim();
                if (gen.isEmpty()) continue;
                this.generify(attr, gen, v.getElementAttributes());
            }
        }

        abstract void generify(ElementAttributes var1, String var2, ElementAttributes var3) throws IOException;
    }

    private static interface Accept {
        public boolean accept(ElementAttributes var1);
    }

    private static final class Matcher
    implements SubstituteInterface {
        private final Accept accept;
        private final SubstituteInterface substituteInterface;

        private Matcher(Accept accept, SubstituteInterface substituteInterface) {
            this.accept = accept;
            this.substituteInterface = substituteInterface;
        }

        @Override
        public ElementTypeDescription getElementType(ElementAttributes attr, ElementLibrary library) throws PinException, IOException {
            if (this.accept.accept(attr)) {
                return this.substituteInterface.getElementType(attr, library);
            }
            return null;
        }
    }

    private static final class SubstituteMatching
    implements SubstituteInterface {
        private final ArrayList<Matcher> matcher = new ArrayList();

        private SubstituteMatching() {
        }

        private SubstituteMatching add(Accept accept, SubstituteInterface substituteInterface) {
            this.matcher.add(new Matcher(accept, substituteInterface));
            return this;
        }

        @Override
        public ElementTypeDescription getElementType(ElementAttributes attr, ElementLibrary library) throws PinException, IOException {
            for (Matcher m : this.matcher) {
                ElementTypeDescription type = m.getElementType(attr, library);
                if (type == null) continue;
                return type;
            }
            return null;
        }
    }

    private static interface SubstituteInterface {
        public ElementTypeDescription getElementType(ElementAttributes var1, ElementLibrary var2) throws PinException, IOException;
    }
}

