/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.ModelAnalyser;
import de.neemann.digital.core.BacktrackException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.NodeWithoutDelay;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.Signal;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;
import java.util.HashMap;

public class PathLenAnalyser {
    private int maxDepth;

    public PathLenAnalyser(ModelAnalyser modelAnalyser) throws BacktrackException, PinException {
        for (Signal s : modelAnalyser.getInputs()) {
            HashMap<ObservableValue, Integer> found = new HashMap<ObservableValue, Integer>();
            this.backtracking(s.getValue(), found, 0);
        }
    }

    private void backtracking(ObservableValue value, HashMap<ObservableValue, Integer> found, int depth) throws PinException, BacktrackException {
        Integer d = found.get(value);
        if (d == null || d < depth) {
            found.put(value, depth);
            if (depth > this.maxDepth) {
                this.maxDepth = depth;
            }
            for (Observer o : value.getObservers()) {
                if (o instanceof NodeInterface) {
                    ObservableValues outputs = ((NodeInterface)o).getOutputs();
                    int de = depth;
                    if (!(o instanceof NodeWithoutDelay)) {
                        ++de;
                    }
                    for (ObservableValue co : outputs) {
                        this.backtracking(co, found, de);
                    }
                    continue;
                }
                throw new BacktrackException(Lang.get("err_backtrackOf_N_isImpossible", o.getClass().getSimpleName()));
            }
        }
    }

    public int getMaxPathLen() {
        return this.maxDepth;
    }
}

