/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.AnalyseException;
import de.neemann.digital.core.BacktrackException;
import de.neemann.digital.core.NodeInterface;
import de.neemann.digital.core.ObservableValue;
import de.neemann.digital.core.ObservableValues;
import de.neemann.digital.core.Observer;
import de.neemann.digital.core.Signal;
import de.neemann.digital.core.switching.Switch;
import de.neemann.digital.core.wiring.bus.CommonBusValue;
import de.neemann.digital.draw.elements.PinException;
import de.neemann.digital.lang.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public final class CycleDetector {
    private CycleDetector() {
    }

    public static void checkForCycles(ArrayList<Signal> values) throws BacktrackException, PinException, CycleException {
        HashMap<NodeInterface, Node> nodes = new HashMap<NodeInterface, Node>();
        HashSet<ObservableValue> visited = new HashSet<ObservableValue>();
        for (Signal s : values) {
            Node root = new Node(null);
            root.layer = 1;
            CycleDetector.traverse(root, s.getValue(), nodes, visited);
        }
        CycleDetector.checkGraphForCycles(nodes.values());
    }

    private static void traverse(Node parent, ObservableValue val, HashMap<NodeInterface, Node> nodes, HashSet<ObservableValue> visited) throws PinException, BacktrackException {
        visited.add(val);
        for (Observer o : val.getObservers()) {
            if (o instanceof NodeInterface) {
                NodeInterface no = (NodeInterface)o;
                Node child = nodes.computeIfAbsent(no, x$0 -> new Node((NodeInterface)x$0));
                child.addParent(parent);
                ObservableValues outputs = ((NodeInterface)o).getOutputs();
                for (ObservableValue co : outputs) {
                    if (visited.contains(co)) continue;
                    CycleDetector.traverse(child, co, nodes, visited);
                }
                continue;
            }
            throw new BacktrackException(Lang.get("err_backtrackOf_N_isImpossible", o.getClass().getSimpleName()));
        }
    }

    private static void removeSwitchCycles(Collection<Node> nodes) {
        for (Node n : nodes) {
            if (!(n.ni instanceof CommonBusValue)) continue;
            for (Node p : n.parents) {
                if (!(p.ni instanceof Switch)) continue;
                p.parents.removeIf(node -> node == n);
            }
        }
    }

    private static void checkGraphForCycles(Collection<Node> nodes) throws CycleException {
        ArrayList<Node> remaining = new ArrayList<Node>(nodes);
        int layer = 1;
        while (!remaining.isEmpty()) {
            ++layer;
            ArrayList<Node> ableToPlace = new ArrayList<Node>();
            for (Node node : remaining) {
                boolean nodeOk = true;
                for (Node p : node.parents) {
                    if (p.layer != 0) continue;
                    nodeOk = false;
                    break;
                }
                if (!nodeOk) continue;
                ableToPlace.add(node);
                node.layer = layer;
            }
            if (ableToPlace.isEmpty()) {
                throw new CycleException();
            }
            remaining.removeAll(ableToPlace);
        }
    }

    static final class CycleException
    extends AnalyseException {
        private CycleException() {
            super(Lang.get("err_circuitHasCycles", new Object[0]));
        }
    }

    private static final class Node {
        private final NodeInterface ni;
        private final ArrayList<Node> parents = new ArrayList();
        private int layer;

        private Node(NodeInterface ni) {
            this.ni = ni;
        }

        private void addParent(Node parent) {
            this.parents.add(parent);
        }

        public String toString() {
            return this.ni.toString();
        }
    }
}

