/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.TruthTable;
import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.BoolTableByteArray;
import de.neemann.digital.lang.Lang;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public final class CSVImporter {
    private CSVImporter() {
    }

    public static TruthTable readCSV(File file) throws IOException {
        return CSVImporter.readCSV(new FileReader(file));
    }

    public static TruthTable readCSV(String csv) throws IOException {
        return CSVImporter.readCSV(new StringReader(csv));
    }

    public static TruthTable readCSV(Reader csv) throws IOException {
        BufferedReader r = new BufferedReader(csv);
        TruthTable tt = CSVImporter.readHeader(r);
        String line;
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            CSVImporter.parseLine(tt, line);
        }
        return tt;
    }

    private static TruthTable readHeader(BufferedReader r) throws IOException {
        String header;
        while ((header = r.readLine()) != null && header.length() == 0) {
        }
        if (header == null) {
            throw new IOException(Lang.get("err_csvNoHeaderFound", new Object[0]));
        }
        ArrayList<Variable> vars = new ArrayList<Variable>();
        TruthTable tt = null;
        for (String ss : header.split(",")) {
            String h = ss.trim();
            if (h.isEmpty()) {
                tt = new TruthTable(vars);
                continue;
            }
            if (tt == null) {
                vars.add(new Variable(h));
                continue;
            }
            tt.addResult(h, new BoolTableByteArray(1 << vars.size()));
        }
        if (tt == null || tt.getResultCount() == 0) {
            throw new IOException(Lang.get("err_csvNoOutputValuesFound", new Object[0]));
        }
        return tt;
    }

    private static void parseLine(TruthTable tt, String line) throws IOException {
        int resNum = tt.getResultCount();
        int varNum = tt.getVars().size();
        int mask = 1 << varNum - 1;
        ArrayList<Integer> dc = new ArrayList<Integer>();
        int row = 0;
        int rCol = 0;
        Generator generator = null;
        for (String ss : line.split(",")) {
            String e = ss.trim().toLowerCase();
            if (e.isEmpty()) {
                generator = new Generator(row, dc);
                continue;
            }
            if (generator == null) {
                if (mask == 0) {
                    throw new IOException(Lang.get("err_csvToManyValues", new Object[0]));
                }
                if (e.equals("1")) {
                    row |= mask;
                } else if (e.equals("x")) {
                    dc.add(mask);
                }
                mask >>= 1;
                continue;
            }
            if (rCol >= resNum) {
                throw new IOException(Lang.get("err_csvToManyValues", new Object[0]));
            }
            if (e.equals("1")) {
                generator.addCol(rCol);
            }
            ++rCol;
        }
        if (mask != 0) {
            throw new IOException(Lang.get("err_csvNotEnoughValues", new Object[0]));
        }
        if (generator != null) {
            generator.applyTo(tt);
        }
    }

    private static final class Generator {
        private final int row;
        private final ArrayList<Integer> dc;
        private final ArrayList<Integer> cols;

        private Generator(int row, ArrayList<Integer> dc) {
            this.row = row;
            this.dc = dc;
            this.cols = new ArrayList();
        }

        public void addCol(int rCol) {
            this.cols.add(rCol);
        }

        public void applyTo(TruthTable tt) {
            if (this.cols.isEmpty()) {
                return;
            }
            int vars = tt.getVars().size();
            if (this.dc.isEmpty()) {
                for (int col : this.cols) {
                    tt.setValue(this.row, vars + col, 1);
                }
            } else {
                int dcRows = 1 << this.dc.size();
                for (int i = 0; i < dcRows; ++i) {
                    int r = this.row;
                    int bitMask = 1;
                    for (int orMask : this.dc) {
                        if ((i & bitMask) != 0) {
                            r |= orMask;
                        }
                        bitMask *= 2;
                    }
                    for (int col : this.cols) {
                        tt.setValue(r, vars + col, 1);
                    }
                }
            }
        }
    }
}

