/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital.analyse;

import de.neemann.digital.analyse.expression.Variable;
import de.neemann.digital.analyse.quinemc.BoolTable;
import de.neemann.digital.analyse.quinemc.BoolTableByteArray;
import de.neemann.digital.analyse.quinemc.ThreeStateValue;
import de.neemann.digital.core.Bits;
import de.neemann.digital.core.Signal;
import java.util.ArrayList;

public class BoolTableExpanded
implements BoolTable {
    private final BoolTableByteArray e;
    private final ArrayList<Variable> vars;
    private final int[] bitsToRemove;
    private final int bitRemoveCount;
    private final int size;

    public BoolTableExpanded(BoolTableByteArray e, ArrayList<Signal> inputs, ArrayList<Signal> originalInputs) {
        this.e = e;
        this.bitRemoveCount = originalInputs.size() - inputs.size();
        this.bitsToRemove = new int[this.bitRemoveCount];
        this.size = 1 << originalInputs.size();
        int bit = 0;
        int c = 0;
        for (int i = originalInputs.size() - 1; i >= 0; --i) {
            Signal s = originalInputs.get(i);
            if (!inputs.contains(s)) {
                this.bitsToRemove[c] = bit;
                ++c;
            }
            ++bit;
        }
        this.vars = new ArrayList();
        for (Signal s : inputs) {
            this.vars.add(new Variable(s.getName()));
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ThreeStateValue get(int i) {
        for (int b = this.bitRemoveCount - 1; b >= 0; --b) {
            i = Bits.removeBitFromValue(i, this.bitsToRemove[b]);
        }
        return this.e.get(i);
    }

    public BoolTableByteArray getBoolTable() {
        return this.e;
    }

    public ArrayList<Variable> getVars() {
        return this.vars;
    }

    @Override
    public int realSize() {
        return this.e.realSize();
    }
}

