/*
 * Decompiled with CFR 0.152.
 */
package de.neemann.digital;

import de.neemann.digital.draw.library.ElementLibrary;
import de.neemann.digital.gui.FileHistory;
import de.neemann.digital.gui.Main;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileLocator.class);
    private static final int MAX_FILE_COUNTER = 5000;
    private final String filename;
    private File file;
    private FileHistory history;
    private File libraryRoot;
    private File baseFile;

    public FileLocator(File file) {
        this(file == null ? null : file.getName());
        this.file = file;
    }

    public FileLocator(String filename) {
        this.filename = filename;
    }

    public FileLocator setHistory(FileHistory history) {
        this.history = history;
        return this;
    }

    public FileLocator setLibrary(ElementLibrary library) {
        this.libraryRoot = library.getRootFilePath();
        return this;
    }

    public FileLocator setLibraryRoot(File libraryRoot) {
        this.libraryRoot = libraryRoot.isFile() ? libraryRoot.getParentFile() : libraryRoot;
        return this;
    }

    public FileLocator setBaseFile(File baseFile) {
        this.baseFile = baseFile;
        return this;
    }

    public FileLocator setupWithMain(Main main) {
        if (main != null) {
            this.setBaseFile(main.getBaseFileName());
            this.setLibrary(main.getLibrary());
        }
        return this;
    }

    public File locate() {
        Object f;
        if (this.file != null && this.file.exists()) {
            return this.file;
        }
        if (this.filename == null) {
            return null;
        }
        if (this.baseFile != null && ((File)(f = new File(this.baseFile.getParentFile(), this.filename))).isFile() && ((File)f).exists()) {
            LOGGER.debug(this.filename + " found in base file folder");
            return f;
        }
        if (this.history != null) {
            for (File h : this.history.getFiles()) {
                if (!h.getName().equals(this.filename) || !h.exists()) continue;
                LOGGER.debug(this.filename + " found in file history");
                return h;
            }
        }
        if (this.libraryRoot != null) {
            LOGGER.debug(this.filename + ": start library folder lookup");
            ArrayList<File> foundFiles = new ArrayList<File>();
            try {
                this.search(this.libraryRoot, foundFiles, 5000);
                if (foundFiles.size() == 1) {
                    LOGGER.debug(this.filename + " found in library folder");
                    return foundFiles.get(0);
                }
            }
            catch (IOException e) {
                LOGGER.debug(this.filename + ": " + e.getMessage());
            }
        }
        LOGGER.debug(this.filename + " not found");
        return this.file;
    }

    private int search(File path, ArrayList<File> foundFiles, int fileCounter) throws IOException {
        File[] list = path.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isFile() && f.getName().equals(this.filename)) {
                    foundFiles.add(f);
                    if (foundFiles.size() > 1) {
                        throw new IOException("multiple matching files: " + foundFiles);
                    }
                }
                if (--fileCounter >= 0) continue;
                throw new IOException("to many files");
            }
            for (File f : list) {
                if (!f.isDirectory() || f.getName().startsWith(".")) continue;
                fileCounter = this.search(f, foundFiles, fileCounter);
            }
        }
        return fileCounter;
    }
}

